set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9232933';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-4-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      NULL,
      NULL,
      NULL,
      NULL,
      16.105948,
      2,
      2.875157,
      NULL,
      NULL,
      2,
      NULL,
      30,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      1.812765,
      3.096717,
      0,
      1,
      0,
      1,
      0.006942,
      NULL,
      1.753577,
      1.386500,
      0.763812,
      0.630926,
      3,
      0,
      1.186288,
      0,
      2.233051,
      5,
      2.972758,
      6,
      NULL,
      5.245175,
      0,
      3.227859,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.868688,
      0.517255,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      1.088714,
      1,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0.789993,
      NULL,
      NULL,
      0,
      3.050822,
      3,
      2.144280,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      0.793004,
      NULL,
      0.222964,
      1,
      1.966187,
      0,
      0.736065,
      1.663740,
      NULL,
      NULL,
      0,
      5,
      NULL,
      5,
      4,
      NULL,
      0.155645,
      1,
      4,
      NULL,
      1.837987,
      1.151007,
      5,
      0,
      6.387485,
      0,
      1.452526,
      8,
      1,
      4,
      1.578609,
      2.156141,
      NULL,
      3,
      2.618297,
      4.842588,
      NULL,
      7,
      NULL,
      0,
      1,
      6.926277,
      1.061128,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.921531,
      0.256050,
      0,
      1,
      0.273615,
      1.875814,
      1.698130,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.053620,
      NULL,
      8,
      2.959792,
      0.307465,
      2,
      3.176214,
      0.512282,
      0,
      1.771765,
      1,
      0.239818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      5.053834,
      4,
      2,
      4.805388,
      0,
      0.416163,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.560207,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.768210,
      3.684799,
      1.073565,
      0,
      3,
      0,
      0.875008,
      0,
      1,
      3,
      NULL,
      0.688062,
      0.970265,
      0.650262,
      0,
      0,
      0.785285,
      1.112224,
      1.410422,
      1.467134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '13401',
      '',
      '',
      0.776853,
      NULL,
      '',
      '',
      1.288887,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


