set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9232933';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-6-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '0',
      NULL,
      NULL,
      '2244040',
      56,
      6,
      NULL,
      NULL,
      '011024',
      3,
      NULL,
      12,
      NULL,
      1,
      NULL,
      18,
      1.021825,
      1,
      0.071659,
      3,
      0,
      0.548967,
      0.669109,
      3.157644,
      1,
      1.160794,
      0,
      NULL,
      0.606575,
      1.987883,
      2.584581,
      11.897858,
      1.089517,
      1,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      3.728369,
      1,
      1.654620,
      NULL,
      NULL,
      0.432329,
      NULL,
      NULL,
      1,
      2.373818,
      2.947015,
      0.974741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.356416,
      0.765334,
      0,
      3,
      0,
      2,
      NULL,
      1.112956,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.895908,
      3,
      NULL,
      4,
      1,
      3.083258,
      NULL,
      1.457295,
      1.606123,
      1.322798,
      0.147176,
      NULL,
      1.240402,
      1.166897,
      0.317191,
      0,
      0.321138,
      0.736360,
      NULL,
      NULL,
      2,
      0.527372,
      1.938369,
      7.448483,
      1,
      NULL,
      1.816360,
      7.549210,
      0,
      0.568599,
      NULL,
      4.911648,
      0.013317,
      5,
      1.328331,
      0,
      2.778967,
      NULL,
      5.144375,
      0,
      7,
      0.993745,
      0.115454,
      10,
      4.372236,
      NULL,
      5.805508,
      1.474232,
      1,
      NULL,
      4.120558,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.528419,
      1.661362,
      1,
      0,
      1.123713,
      0.502033,
      1.516173,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      3,
      0,
      0.573699,
      3,
      7.851447,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1.794703,
      0,
      0.949944,
      NULL,
      NULL,
      NULL,
      0.136015,
      7.958417,
      0.178194,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.387422,
      1,
      3,
      0.345387,
      NULL,
      NULL,
      1.838627,
      NULL,
      1.850087,
      3.077829,
      NULL,
      1,
      NULL,
      0.431550,
      1,
      0.671892,
      0.409566,
      0,
      0.926924,
      0.842678,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.153507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '01324',
      '',
      '',
      0.749742,
      NULL,
      '',
      NULL,
      1.551898,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


