set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9232933';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-6-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '112',
      NULL,
      0.145579,
      6.504080,
      '0210014',
      74.155964,
      NULL,
      3,
      2,
      '211412',
      NULL,
      ' 2-12-1992',
      18.242815,
      47,
      0.013221,
      NULL,
      3,
      0.534470,
      0.389746,
      0.126629,
      0.871120,
      NULL,
      1,
      1,
      0.242259,
      1,
      5,
      0,
      0,
      1.763441,
      NULL,
      1.620814,
      3.393776,
      0,
      1.123543,
      1,
      0,
      1.067883,
      4.773102,
      3,
      2.031039,
      2,
      1.718674,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.758681,
      1.553361,
      NULL,
      0.202908,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3.465034,
      NULL,
      2,
      1,
      1.096065,
      1.199800,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      4,
      6,
      2.255779,
      6.875938,
      0,
      4,
      2,
      0,
      1.411427,
      1.658370,
      0.122256,
      1,
      3.008117,
      NULL,
      1,
      0.929424,
      1,
      NULL,
      NULL,
      1.161643,
      1,
      NULL,
      0.639311,
      NULL,
      0.660552,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2,
      5,
      5.500005,
      2,
      5.047231,
      6,
      0.058658,
      8.552465,
      0.257103,
      NULL,
      NULL,
      NULL,
      6,
      2.345356,
      1,
      1,
      NULL,
      1.692100,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.544884,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      3.855731,
      1.383450,
      1.286336,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      7.949576,
      NULL,
      NULL,
      0,
      1.146227,
      NULL,
      NULL,
      NULL,
      0.737061,
      NULL,
      0.798263,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.328993,
      2.579894,
      NULL,
      0.585053,
      3.427969,
      NULL,
      1.463759,
      NULL,
      2.678738,
      2.958065,
      2,
      NULL,
      1,
      0,
      1,
      1,
      0,
      1.119831,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.179060,
      '40441',
      '',
      '',
      1,
      '',
      '',
      '',
      1.000335,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


