set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9528612';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-3-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '243',
      '32',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '213023',
      3,
      '11-11-2000',
      NULL,
      43.239386,
      1.965284,
      NULL,
      0.624896,
      1,
      0,
      1,
      0.000040,
      2,
      NULL,
      0,
      0,
      0,
      NULL,
      0.072156,
      NULL,
      1.438103,
      1,
      1,
      2.557101,
      NULL,
      0,
      0,
      0.906989,
      1.617908,
      4,
      NULL,
      3.914620,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.682805,
      NULL,
      NULL,
      0.062334,
      1,
      1,
      0.865767,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.492662,
      1,
      1.361212,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.176676,
      1.718248,
      4,
      0,
      1,
      0,
      NULL,
      1.300123,
      0,
      NULL,
      0,
      0.061395,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      0.193794,
      0,
      0.992135,
      NULL,
      0,
      NULL,
      1.817490,
      1,
      0,
      3,
      1,
      NULL,
      7.294508,
      0,
      7,
      NULL,
      0,
      3.170503,
      NULL,
      5,
      0.236073,
      6.847456,
      3.946247,
      1,
      NULL,
      NULL,
      1,
      1.772685,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.394106,
      0,
      0,
      1.460149,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.097596,
      NULL,
      0,
      2,
      0.938490,
      6.731443,
      1,
      3,
      NULL,
      0.211187,
      NULL,
      7.436444,
      0.999743,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.205019,
      2.729632,
      5,
      5.996223,
      1,
      2.397815,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.021299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.993947,
      3.755652,
      NULL,
      0,
      1.392405,
      0,
      NULL,
      1,
      1,
      1,
      0,
      1.534671,
      1,
      NULL,
      0.819482,
      0.620230,
      NULL,
      1,
      0.367591,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      '',
      1.699628,
      '',
      '',
      '',
      0.301945,
      '',
      '',
      '',
      0.521111,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


