set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9528612';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-10-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '311',
      NULL,
      19,
      NULL,
      '3014140',
      33,
      6,
      NULL,
      1,
      '241010',
      5.417564,
      ' 9-21-1974',
      41.759921,
      69,
      1,
      NULL,
      5,
      NULL,
      0,
      1.484024,
      1,
      0,
      1.924433,
      1.546782,
      0,
      1.572122,
      1,
      NULL,
      0.153121,
      0.459337,
      1,
      1.894665,
      0,
      0,
      1.695027,
      NULL,
      1.445434,
      0.232572,
      1.750276,
      1,
      0.242304,
      1.937289,
      1.713696,
      0.006347,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.864850,
      1,
      0,
      0.600051,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.746016,
      1,
      1.909028,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.904402,
      0,
      0,
      1,
      1.053327,
      1,
      0.233469,
      1.087745,
      1,
      1,
      1,
      0.920047,
      NULL,
      0,
      1.235433,
      1.251501,
      0,
      1,
      NULL,
      1.394399,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.506219,
      4.982958,
      0,
      1.230571,
      0.593010,
      0.771508,
      1,
      3.716610,
      NULL,
      NULL,
      3.232969,
      4.498598,
      1,
      0,
      5,
      NULL,
      7,
      5,
      0,
      0.490394,
      NULL,
      1,
      NULL,
      NULL,
      9,
      0.715554,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.021113,
      0,
      1,
      1,
      0.922787,
      1.301053,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.762794,
      3,
      2.201919,
      0,
      0.829745,
      NULL,
      1.343796,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.707589,
      NULL,
      0.573314,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0.936395,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.216380,
      0.722867,
      3.006843,
      NULL,
      2,
      0.374879,
      3,
      2.171701,
      1,
      1.289976,
      3.536523,
      1,
      1.784121,
      NULL,
      1,
      1.177239,
      0.453940,
      NULL,
      NULL,
      0.088980,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '21310',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.665522,
      '',
      '',
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


