set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9528612';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-4-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '14032124',
      28,
      61.953137,
      '1440243',
      90.555981,
      NULL,
      1.510506,
      2,
      '130000',
      4,
      ' 2-13-2000',
      17,
      NULL,
      0.193280,
      NULL,
      1.454066,
      3.620613,
      0,
      NULL,
      0,
      0,
      0.313269,
      1,
      1.556312,
      0,
      NULL,
      0,
      NULL,
      1,
      1.325721,
      1,
      1.193610,
      NULL,
      1.872337,
      0.960670,
      1,
      0.867987,
      0.772413,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.678772,
      0,
      1.116128,
      1.914393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.751823,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.104093,
      0.367203,
      1.571651,
      0.839039,
      0.322560,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      0.309465,
      0.169213,
      1.821565,
      NULL,
      0,
      NULL,
      0,
      0.841184,
      1,
      0.229130,
      0.262414,
      1.410904,
      1,
      NULL,
      2,
      0.223795,
      NULL,
      NULL,
      1,
      1,
      3.543417,
      1,
      7.996021,
      NULL,
      NULL,
      3,
      2.700415,
      4.727363,
      3,
      7.584883,
      2,
      0.030808,
      1.258800,
      1,
      1.322678,
      NULL,
      NULL,
      7,
      1.538889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.148827,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      1.216085,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.003702,
      NULL,
      6.040865,
      0.083657,
      0.585092,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.717357,
      0.000540,
      NULL,
      NULL,
      NULL,
      0,
      0.822885,
      2,
      3.264827,
      2.537743,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.718418,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.467866,
      2.275450,
      0,
      3.843018,
      0,
      3,
      1,
      NULL,
      0,
      2.596312,
      0.160401,
      0.903953,
      1,
      1.219596,
      NULL,
      0,
      1.956530,
      1.279156,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.033234,
      NULL,
      NULL,
      '',
      0.359466,
      '',
      NULL,
      '',
      1.824100,
      '',
      '',
      '',
      NULL,
      3,
      3,
      NULL,
      3,
      0.108197,
      2,
      1.611762,
      1);
commit;
end;
/


