set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9659883';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-5-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '221',
      '11',
      29.341126,
      2,
      '3403024',
      3.583026,
      2,
      NULL,
      0,
      '101232',
      NULL,
      ' 9-22-1975',
      41,
      45.911344,
      0,
      NULL,
      1.229551,
      1,
      0.830543,
      0.746688,
      1.283901,
      0,
      3.259814,
      0,
      0.810023,
      0,
      5.689160,
      0.747944,
      1,
      7,
      3,
      NULL,
      3.570691,
      0,
      1.840857,
      1.060276,
      0.860253,
      0,
      3,
      NULL,
      3,
      5.951554,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.900761,
      0.373822,
      0.373795,
      NULL,
      2.038651,
      3,
      NULL,
      0.406707,
      0,
      NULL,
      0.509186,
      2,
      1.589422,
      2,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      6,
      NULL,
      1,
      0,
      1.085956,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.476961,
      0.863007,
      4.630603,
      0,
      1.248190,
      0,
      4,
      1,
      0.551285,
      0.198292,
      1.364085,
      1,
      1,
      1,
      0,
      0,
      0.572358,
      NULL,
      0.466579,
      NULL,
      1.622947,
      0.453586,
      3,
      0,
      1,
      1.013301,
      1,
      1.239000,
      5,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.055071,
      1.040278,
      4.446853,
      NULL,
      6,
      2.128970,
      7.968449,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.550304,
      NULL,
      1,
      0.737535,
      NULL,
      8.979514,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.452854,
      1,
      0,
      2,
      NULL,
      1.887452,
      5.477799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      7.537886,
      0.221356,
      3,
      NULL,
      1,
      0.813359,
      0,
      1.907943,
      1.480535,
      1,
      NULL,
      1.151788,
      NULL,
      NULL,
      NULL,
      1,
      0.219880,
      0,
      6,
      1.153796,
      0,
      7.045338,
      NULL,
      NULL,
      NULL,
      NULL,
      7.562116,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.382797,
      NULL,
      0,
      1,
      NULL,
      3,
      1.846433,
      2,
      0.070110,
      NULL,
      3,
      0,
      1.276131,
      0,
      1,
      0,
      0.366161,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '41424',
      '',
      '',
      1.338212,
      NULL,
      '',
      NULL,
      0.860956,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


