set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9659883';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-10-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '131',
      '24',
      9,
      14,
      '1114210',
      25.656419,
      NULL,
      3.339109,
      NULL,
      '113341',
      NULL,
      ' 8-14-1999',
      45.715881,
      13.417288,
      NULL,
      NULL,
      2.885785,
      1.938162,
      1.112493,
      1,
      0,
      1.036188,
      3.053735,
      0.699945,
      1,
      1.164084,
      1.558914,
      1.197061,
      0,
      4.420832,
      NULL,
      0,
      NULL,
      0.157436,
      NULL,
      1.214462,
      4,
      NULL,
      5.747146,
      0,
      4.871605,
      1.781558,
      1.452160,
      0.731937,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.775271,
      0,
      NULL,
      0.549913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.181621,
      0,
      1,
      2.167699,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.151430,
      1.829033,
      NULL,
      1.797806,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1,
      0,
      NULL,
      0,
      NULL,
      1.496485,
      0.345854,
      1,
      NULL,
      0.156258,
      0.166882,
      NULL,
      1,
      0.443706,
      0,
      1.922460,
      NULL,
      3.560863,
      1.474923,
      1.481984,
      0.689005,
      1.054251,
      NULL,
      0,
      0,
      2,
      4,
      NULL,
      7,
      4.901131,
      NULL,
      1,
      0,
      1.698483,
      1.087968,
      2,
      3.881716,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2,
      1,
      NULL,
      1,
      NULL,
      1.429372,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      8,
      0,
      2.841606,
      NULL,
      1.769647,
      0.293793,
      0,
      2,
      3,
      3.423666,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.165221,
      7.756645,
      NULL,
      4,
      2,
      9,
      NULL,
      NULL,
      NULL,
      0.241086,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.193335,
      0.255717,
      2.801675,
      3.280705,
      1,
      0,
      1.154893,
      NULL,
      NULL,
      0.906053,
      NULL,
      0,
      1,
      1,
      0,
      0.869210,
      1,
      0.135703,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.421314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '24142',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.242413,
      '',
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


