set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8816668';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-6-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '440',
      '44433113',
      45,
      64.927983,
      '0411421',
      NULL,
      1,
      0.429329,
      1,
      NULL,
      5.916906,
      ' 3-23-1999',
      17.209502,
      57.611247,
      0,
      NULL,
      NULL,
      3,
      1.779880,
      0.464679,
      1,
      1,
      1.788799,
      1,
      0.619217,
      0.443185,
      1.413541,
      0.589255,
      0,
      1,
      1,
      1,
      1.752410,
      NULL,
      1.111161,
      1.337285,
      0,
      NULL,
      1.504233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.247296,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.128949,
      0.718100,
      0,
      0.375148,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.235719,
      0.146851,
      0,
      0.602523,
      1,
      1,
      0.809159,
      0,
      NULL,
      1.323691,
      0,
      0,
      0.686982,
      1.596071,
      1,
      NULL,
      0,
      1.013291,
      1.390033,
      NULL,
      1.995741,
      4,
      1,
      1,
      3.308783,
      NULL,
      3,
      1,
      1,
      NULL,
      3,
      5,
      2.683334,
      3,
      5,
      0,
      4.445330,
      1,
      4,
      0,
      5.878734,
      2.389052,
      3,
      6.165664,
      3,
      2.990838,
      1,
      4.905707,
      0,
      NULL,
      NULL,
      7.853530,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.005149,
      1,
      NULL,
      1.315254,
      1,
      0.561242,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.329326,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0.710811,
      NULL,
      NULL,
      NULL,
      1.871851,
      0,
      NULL,
      2,
      0.597711,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.331804,
      0,
      0.749330,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.097517,
      1,
      0.726968,
      1,
      NULL,
      2,
      0.155256,
      NULL,
      NULL,
      1,
      0.637563,
      0,
      1,
      0,
      1,
      1,
      1.866871,
      0.789219,
      1.326889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4.415083,
      '2131',
      '4313',
      NULL,
      NULL,
      '',
      '',
      '',
      0.585795,
      NULL,
      '',
      '',
      2,
      1,
      NULL,
      3,
      1.708664,
      1.536930,
      2,
      3.069661,
      1);
commit;
end;
/


