set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8816668';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-1-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4330',
      '31041112',
      NULL,
      9.673401,
      NULL,
      124.836319,
      2,
      1.606471,
      NULL,
      '121322',
      1.450749,
      ' 3- 7-1995',
      17,
      46,
      0.919906,
      NULL,
      0.299648,
      1.760739,
      1.754407,
      NULL,
      1,
      1.985910,
      0.889535,
      0,
      0.190830,
      1,
      NULL,
      0,
      0,
      NULL,
      0.284760,
      1.816483,
      NULL,
      1,
      1,
      0,
      0.129049,
      0.645175,
      1.838154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.704664,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.663863,
      1,
      1,
      NULL,
      0,
      1,
      1,
      1.992185,
      0.327999,
      1,
      1,
      0.442422,
      0,
      0,
      1.209561,
      0,
      NULL,
      0,
      1,
      NULL,
      0.423622,
      1,
      NULL,
      0.624975,
      0,
      NULL,
      0.278297,
      2.731758,
      NULL,
      NULL,
      NULL,
      NULL,
      5.389113,
      5,
      NULL,
      1.698285,
      3.741472,
      7,
      4.882305,
      NULL,
      NULL,
      NULL,
      0,
      4.046041,
      7.522154,
      4,
      0.016653,
      2,
      1.816610,
      NULL,
      NULL,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.694139,
      NULL,
      NULL,
      0,
      1,
      1.956115,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.736207,
      NULL,
      NULL,
      NULL,
      NULL,
      0.423968,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.898920,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.261869,
      1,
      1.835834,
      1,
      2,
      0.114379,
      NULL,
      NULL,
      NULL,
      0,
      1.597428,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.448271,
      3.282940,
      3.086723,
      NULL,
      1,
      0.300773,
      0,
      NULL,
      1.865423,
      NULL,
      0,
      1,
      1,
      0,
      1.211800,
      1,
      1.088500,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.534838,
      '4313',
      '3334',
      '',
      0.797228,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      0.669873,
      NULL,
      2.213546,
      NULL,
      1,
      1,
      1.397660,
      NULL,
      NULL);
commit;
end;
/


