set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9630675';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2312',
      '21412030',
      58.172536,
      61,
      NULL,
      11.430782,
      NULL,
      1.824841,
      3,
      '044024',
      4.319639,
      NULL,
      32.946636,
      1,
      1.588826,
      NULL,
      3,
      0,
      0.651759,
      1.970808,
      1.048628,
      NULL,
      1,
      1.566846,
      2.653006,
      1.559158,
      NULL,
      0,
      NULL,
      0.293349,
      0.850020,
      1,
      0,
      NULL,
      NULL,
      0,
      1.414814,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.361241,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.329220,
      0.049728,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.979482,
      1,
      0,
      0.211172,
      0.507592,
      0.446116,
      0,
      NULL,
      0.173844,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      1.033460,
      0.438176,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      0.728324,
      1.479691,
      0,
      1.630828,
      1,
      0,
      NULL,
      1.333818,
      1.762173,
      0,
      0,
      0.709010,
      0.070426,
      NULL,
      3,
      1.874232,
      2.890701,
      0.737016,
      0.022377,
      0,
      4.335317,
      1,
      0.012642,
      1.798198,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.277131,
      1,
      NULL,
      1.579631,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.137643,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.158923,
      2.912016,
      1.838639,
      0,
      0.418449,
      1.677665,
      3,
      1.508530,
      NULL,
      NULL,
      NULL,
      1.311228,
      1.998685,
      0.705250,
      1.172996,
      NULL,
      2,
      1.099319,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.752300,
      0,
      NULL,
      1.107529,
      3.231925,
      1,
      0.466967,
      0,
      1.457390,
      0,
      NULL,
      1.733020,
      NULL,
      1,
      1.524676,
      2,
      NULL,
      1,
      1.145316,
      1.921687,
      NULL,
      0,
      0.691335,
      0.829717,
      2.637863,
      NULL,
      1.613399,
      1.056415,
      1.091346,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      0,
      1.387539,
      1.966700,
      NULL,
      0.281372,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '02210',
      '41313',
      '30210',
      0.296405,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.565258,
      1.094743,
      0,
      2,
      1);
commit;
end;
/


