set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9215695';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-1-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '02043432',
      41,
      43,
      '0034010',
      6,
      2,
      2,
      2,
      '001303',
      NULL,
      ' 4- 3-1998',
      NULL,
      81,
      NULL,
      NULL,
      NULL,
      1.607453,
      NULL,
      0.825615,
      0,
      0.092737,
      0.982743,
      1.843256,
      0.660549,
      1,
      1.169483,
      0.313144,
      NULL,
      1.828155,
      0.517632,
      0,
      0.891838,
      NULL,
      0,
      0,
      1,
      0.503035,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.481781,
      0.307324,
      0.537263,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.609101,
      NULL,
      1,
      1.872020,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.284894,
      0.389230,
      0,
      0.735783,
      0.333617,
      0.829680,
      0,
      0,
      1.018061,
      0,
      0,
      0,
      0,
      0.018191,
      1,
      0.627539,
      1.457804,
      0.403861,
      NULL,
      0.139579,
      0.911152,
      1,
      0,
      NULL,
      0.906241,
      2.003525,
      0.059947,
      NULL,
      NULL,
      NULL,
      NULL,
      3.476463,
      2.079959,
      3,
      0,
      1.774374,
      5,
      2.592505,
      1.414547,
      5,
      8,
      2.966257,
      8,
      7,
      0.756247,
      0.157146,
      NULL,
      1.748153,
      NULL,
      NULL,
      3,
      0.432138,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.633107,
      1,
      1,
      NULL,
      1,
      1.236067,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.297578,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.743378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.798996,
      1.256343,
      NULL,
      0,
      NULL,
      1,
      1.413525,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.270660,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.888265,
      0,
      2,
      1,
      2.384253,
      1,
      NULL,
      NULL,
      0.206619,
      0.973832,
      0.152998,
      1.771838,
      1,
      1,
      NULL,
      1.298419,
      1.746926,
      1.013480,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.789678,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.889524,
      '30021',
      '42300',
      '04241',
      NULL,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      3,
      7.358242,
      2.022630,
      0,
      NULL,
      5,
      2,
      3.582777,
      2.787938);
commit;
end;
/


