set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9215695';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-7-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '21321022',
      70,
      34,
      '0323000',
      29,
      3,
      0,
      3,
      '203421',
      2,
      ' 3-10-1987',
      58,
      21,
      1,
      NULL,
      1.535190,
      0.366762,
      NULL,
      0,
      1,
      1.004727,
      1.224982,
      3,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      0.140783,
      1.909809,
      1.517412,
      1,
      1,
      0,
      1,
      1,
      0.497505,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.655391,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.521599,
      0.694277,
      0,
      1.853970,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.517242,
      1,
      1.449136,
      1,
      1.839705,
      1,
      1,
      NULL,
      1.992421,
      1.193597,
      1.624238,
      0,
      NULL,
      0.104170,
      0.381211,
      0.636408,
      0,
      0.767402,
      NULL,
      1,
      5,
      0,
      1,
      NULL,
      0,
      3.423000,
      1.335942,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      6.345495,
      1.350517,
      0.938810,
      5,
      1,
      1.552858,
      7,
      NULL,
      5,
      11,
      9,
      1.837155,
      1,
      0.400704,
      0,
      NULL,
      NULL,
      1.396732,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      0.501093,
      1.519093,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.893487,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.757730,
      1.416079,
      NULL,
      NULL,
      NULL,
      0.728704,
      1,
      9.016350,
      1.913920,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.268769,
      0.791656,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.428816,
      1.922973,
      0.778566,
      1.174416,
      1.125275,
      NULL,
      0,
      1.354183,
      1.018058,
      1.943302,
      1,
      0.432501,
      0,
      0,
      0,
      1.949417,
      0,
      1.905391,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.997138,
      NULL,
      '00233',
      '34243',
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.359468,
      7.291004,
      1,
      1.916554,
      6,
      3.355103,
      0.909879,
      1.301079,
      NULL);
commit;
end;
/


