set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9215695';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-2-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '02412320',
      38,
      NULL,
      NULL,
      NULL,
      3,
      0.990261,
      0,
      NULL,
      NULL,
      '10- 9-1991',
      35.794794,
      18,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0,
      1,
      1,
      5,
      NULL,
      NULL,
      1.405024,
      0,
      NULL,
      8,
      0.619052,
      NULL,
      1,
      0.566290,
      1,
      7.020286,
      1,
      2.505501,
      NULL,
      NULL,
      0.932163,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      2.858900,
      1.924630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.874910,
      1,
      0.379294,
      2.708241,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.495848,
      7,
      NULL,
      NULL,
      NULL,
      1.018471,
      1.907723,
      2.808345,
      NULL,
      1,
      NULL,
      1,
      3.743108,
      1.387839,
      0,
      1.920779,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.512225,
      0.022268,
      0.518498,
      3.154834,
      2.859769,
      NULL,
      7,
      NULL,
      NULL,
      0,
      6.354153,
      1.551649,
      NULL,
      0.049323,
      NULL,
      0,
      4,
      1,
      0,
      2.330184,
      0,
      5.719972,
      0.644949,
      NULL,
      NULL,
      2,
      0.697007,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0.764147,
      NULL,
      1,
      0.508819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.899731,
      NULL,
      NULL,
      NULL,
      NULL,
      1.310231,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.777667,
      NULL,
      2,
      3.900027,
      5,
      0.463668,
      1,
      3,
      1,
      NULL,
      1.872415,
      NULL,
      NULL,
      NULL,
      0.542314,
      3.696087,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.605989,
      1.996814,
      1.551969,
      1.418772,
      0,
      NULL,
      3,
      2,
      1.805614,
      1.206356,
      NULL,
      1,
      1.493573,
      1.261021,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.681110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.488922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.600324,
      NULL,
      NULL,
      1.601610,
      1.385288,
      NULL,
      1.595218,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.078524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '01324',
      '10431',
      '41403',
      0.603843,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      4.658352,
      4,
      NULL,
      NULL,
      0.311146,
      5,
      3,
      4.578134,
      1);
commit;
end;
/


