set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9700367';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-2-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '414',
      NULL,
      13.921132,
      42,
      '0132043',
      0.676174,
      NULL,
      NULL,
      0,
      '032214',
      3.803353,
      ' 7-22-1998',
      21.882916,
      NULL,
      1,
      NULL,
      0.153269,
      2.586611,
      1.906296,
      NULL,
      1,
      2,
      NULL,
      NULL,
      0.869096,
      1.129064,
      0.842127,
      NULL,
      1.703738,
      1,
      0,
      0.073842,
      3.165362,
      0,
      1,
      1.992605,
      NULL,
      NULL,
      3.478300,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.099088,
      1.078962,
      0.080414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.983846,
      1,
      1,
      1,
      0,
      1.435807,
      1,
      0,
      0.458086,
      0.471499,
      0.517285,
      0.875454,
      NULL,
      1,
      NULL,
      1.057824,
      0,
      NULL,
      NULL,
      NULL,
      0.717678,
      1,
      0,
      1,
      1,
      0,
      NULL,
      0,
      1.185439,
      0.752104,
      0.534651,
      0,
      1.269927,
      0,
      0.256062,
      3.054814,
      2.650125,
      5,
      7.699264,
      4.518087,
      0,
      NULL,
      1,
      7.250171,
      1.671931,
      0.445795,
      0,
      1,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1.807373,
      NULL,
      1.532091,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      2.175960,
      0,
      3.040370,
      7,
      0.089770,
      3.314352,
      1,
      1,
      5.148419,
      1,
      3.881151,
      0.497283,
      NULL,
      NULL,
      NULL,
      NULL,
      0.687576,
      7.082008,
      2.209337,
      5,
      2,
      1.935603,
      NULL,
      NULL,
      NULL,
      1.060114,
      2,
      0.940962,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.654885,
      1.246341,
      0.031811,
      0,
      1,
      1.705232,
      1,
      0,
      1,
      NULL,
      1.185434,
      0,
      0,
      1.635778,
      0,
      0.163037,
      1.647244,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.688079,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.074523,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      0.794043,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.548230,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      3.048889,
      0.370083,
      1.356549,
      2,
      3.001933,
      '31011',
      '00334',
      '44323',
      1.230695,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      2.687516,
      NULL,
      3,
      5.950616,
      NULL,
      2,
      3.458974,
      3.511184,
      NULL);
commit;
end;
/


