set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9700367';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-11-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '000',
      '41033411',
      18,
      11.556526,
      '4414230',
      13,
      5,
      3,
      NULL,
      '333304',
      3.336432,
      ' 2- 1-1994',
      NULL,
      56.719804,
      1.053448,
      NULL,
      1,
      1.196458,
      1,
      NULL,
      0,
      1.484600,
      0.127646,
      NULL,
      NULL,
      0,
      1.798901,
      0.612068,
      NULL,
      NULL,
      0,
      0.110722,
      2.344856,
      0.612912,
      0,
      1,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1.338330,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.078769,
      NULL,
      1.885517,
      0.865872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      0.827621,
      0.419922,
      1.340031,
      NULL,
      NULL,
      1.112574,
      1,
      1.449303,
      0,
      1,
      0,
      0.964887,
      NULL,
      NULL,
      NULL,
      1.505557,
      NULL,
      0.600284,
      1,
      1.275246,
      2,
      1,
      1.070855,
      NULL,
      NULL,
      1,
      1.352815,
      NULL,
      NULL,
      1.516273,
      NULL,
      7.117042,
      NULL,
      7.137787,
      NULL,
      4,
      NULL,
      2.040520,
      3.994912,
      NULL,
      0.071616,
      1,
      1.914282,
      NULL,
      NULL,
      8.055081,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.000169,
      1.820355,
      0.182978,
      0.330847,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.440048,
      NULL,
      NULL,
      NULL,
      NULL,
      0.730393,
      1,
      2.893222,
      NULL,
      0.575127,
      3.297389,
      4,
      3.553491,
      1.024458,
      NULL,
      NULL,
      NULL,
      3,
      4,
      NULL,
      NULL,
      1.027832,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      1,
      1.778109,
      1.558569,
      2,
      NULL,
      1.984437,
      0.380229,
      0.801634,
      0.159690,
      0,
      0.570610,
      0.887813,
      0.493402,
      1.332196,
      1.731912,
      0.587534,
      1.030529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.266889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.706375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.018803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.724600,
      NULL,
      NULL,
      NULL,
      NULL,
      1.032895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.008083,
      3,
      3,
      2.117477,
      NULL,
      1.573017,
      1,
      4,
      '00004',
      '10021',
      '14320',
      1.205003,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      3,
      2.058823,
      0,
      NULL,
      1,
      5,
      2,
      NULL,
      2);
commit;
end;
/


