set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9700367';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3320',
      '30322030',
      5.556406,
      38.320414,
      '2324431',
      34.255478,
      6,
      3.044109,
      1,
      '241104',
      4.062357,
      '10-25-1975',
      63.956577,
      20.527352,
      NULL,
      NULL,
      1.526493,
      0,
      NULL,
      NULL,
      1.240782,
      0.946683,
      NULL,
      2.972923,
      NULL,
      NULL,
      1.298191,
      0,
      NULL,
      0.320428,
      1.503016,
      NULL,
      0.963191,
      0.057787,
      0,
      0,
      1.740300,
      0.420754,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.056321,
      0,
      0.785224,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.461819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.052762,
      0.140794,
      NULL,
      0.776176,
      NULL,
      0,
      0.815502,
      1.517351,
      0,
      1.130962,
      1.593183,
      1,
      NULL,
      0,
      0.317554,
      NULL,
      1,
      0,
      NULL,
      0.055472,
      1,
      0.391528,
      0,
      0,
      NULL,
      0.045772,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.458970,
      1,
      NULL,
      1.527127,
      1,
      1,
      8.243123,
      3,
      2.904612,
      0,
      4.222370,
      5,
      NULL,
      0,
      1,
      0,
      0.250400,
      NULL,
      NULL,
      8.712007,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.386135,
      0.028194,
      1,
      1,
      0.374683,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.132716,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      2.344498,
      1,
      1,
      2.970605,
      1.750123,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.532077,
      1.300398,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.131750,
      1,
      0,
      0,
      NULL,
      1.259605,
      NULL,
      NULL,
      0.895336,
      3,
      0.943656,
      0.914961,
      1,
      1.435915,
      0,
      NULL,
      0,
      0.780683,
      1,
      1.453898,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.426310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.845079,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.083084,
      NULL,
      0.507309,
      1,
      1,
      NULL,
      5.531842,
      '40134',
      NULL,
      NULL,
      1.772009,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      3.145017,
      4.088155,
      3,
      3,
      3.820976,
      NULL,
      NULL,
      1.018529,
      NULL);
commit;
end;
/


