set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9700367';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-5-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3334',
      '10342223',
      8,
      6,
      NULL,
      16.765551,
      5,
      0,
      3,
      '000004',
      2.385886,
      ' 8- 1-2000',
      28,
      9,
      1,
      NULL,
      2,
      0,
      1.416904,
      0,
      0,
      0,
      0.258718,
      0,
      NULL,
      0,
      0,
      1.368590,
      NULL,
      NULL,
      1.751552,
      0.272736,
      0.337151,
      1.854939,
      1,
      0,
      NULL,
      0.419055,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.653107,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.326850,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.112766,
      NULL,
      1,
      1.784367,
      1,
      1,
      0.254036,
      0,
      NULL,
      1,
      1,
      0.837511,
      0,
      0.689503,
      1.108441,
      NULL,
      0,
      0.976499,
      NULL,
      1,
      0,
      0.184662,
      0.713060,
      0,
      1,
      NULL,
      0.778675,
      1,
      0,
      0.486705,
      1.064637,
      NULL,
      1.613658,
      1.043997,
      0,
      0,
      NULL,
      2.556147,
      0.314213,
      0.932946,
      1,
      NULL,
      0.407088,
      0,
      0.332495,
      NULL,
      0,
      1,
      NULL,
      NULL,
      5,
      1.003679,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.681278,
      NULL,
      0,
      0,
      0.531612,
      0.646926,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.054335,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.400533,
      1,
      4.545588,
      5.762723,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.229272,
      0.663301,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.131261,
      NULL,
      1.376459,
      NULL,
      NULL,
      0.777249,
      0,
      1.096534,
      NULL,
      1.968930,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      1.668184,
      1.609105,
      1.329287,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.336965,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.106995,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.237669,
      NULL,
      1.686731,
      0.071471,
      0,
      2,
      1.803453,
      '20003',
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      2.342505,
      1,
      0.700922,
      NULL,
      NULL,
      2,
      1,
      3.061519);
commit;
end;
/


