set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9700367';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-10-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2211',
      '24334432',
      11.802608,
      58.031609,
      '0220002',
      68,
      0,
      2.085372,
      1,
      '204014',
      4,
      ' 0- 4-1986',
      45.849341,
      53.342188,
      NULL,
      NULL,
      2,
      0.943077,
      NULL,
      1.935115,
      0.225913,
      3,
      1,
      1.574785,
      1,
      0.167781,
      1.639141,
      1.069620,
      0,
      NULL,
      0.461082,
      0.946395,
      1.502208,
      NULL,
      1.065835,
      0.870424,
      1.861334,
      1.237719,
      1.500386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.814293,
      1.841640,
      1.512523,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.053115,
      1,
      NULL,
      0.202452,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.636634,
      1.594409,
      0.536721,
      NULL,
      NULL,
      1.328660,
      0.580650,
      0,
      1,
      0,
      NULL,
      1.652883,
      0.492795,
      NULL,
      1.433948,
      1,
      1,
      NULL,
      NULL,
      1.396848,
      1,
      1.444130,
      0.471558,
      0,
      0.229092,
      NULL,
      0,
      0.080068,
      NULL,
      1.356834,
      NULL,
      0,
      NULL,
      NULL,
      1.987352,
      0,
      NULL,
      4,
      2.337734,
      5,
      1.976159,
      0,
      1,
      0,
      1.736124,
      NULL,
      1,
      0.095226,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0.290725,
      1.241859,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.315566,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.264213,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.310673,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.000699,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.684355,
      0.522648,
      1,
      0,
      0,
      1.394954,
      0.100359,
      1.382539,
      1,
      1.668384,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      0.581207,
      0.842897,
      0,
      0.340422,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.769383,
      0.800073,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.960749,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.170326,
      0,
      1,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      '03143',
      '12213',
      '44000',
      0,
      '',
      '',
      NULL,
      1,
      '',
      '',
      NULL,
      1.620761,
      1,
      NULL,
      0,
      2.370964,
      0.620661,
      0,
      1.044885,
      NULL);
commit;
end;
/


