set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7716787';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-8-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '030',
      '00304324',
      NULL,
      NULL,
      '0413323',
      29,
      1,
      0,
      0,
      '401113',
      0.566727,
      NULL,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      1,
      1,
      NULL,
      0.715172,
      NULL,
      1,
      NULL,
      0.043875,
      0.305741,
      1.793504,
      1.855604,
      0,
      2.283603,
      1.579760,
      1,
      0.440562,
      0,
      0,
      1.390432,
      NULL,
      0.467269,
      0.991703,
      0,
      0.579960,
      NULL,
      NULL,
      1.416487,
      NULL,
      NULL,
      NULL,
      1.133639,
      0.564130,
      0.531303,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.332599,
      NULL,
      1.449052,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      0.765828,
      1,
      NULL,
      1.952726,
      4.498363,
      NULL,
      1,
      NULL,
      1.566352,
      1.700935,
      0,
      0.821890,
      1,
      1.252583,
      NULL,
      1,
      0,
      0,
      1,
      0.763041,
      NULL,
      1.239557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.793508,
      0.424819,
      1,
      1,
      NULL,
      0.352216,
      NULL,
      4,
      9,
      2,
      3,
      2.714987,
      NULL,
      1.469950,
      1,
      1.725745,
      0.429743,
      NULL,
      NULL,
      8.411725,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.421570,
      0,
      1,
      1,
      1.535640,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.549254,
      NULL,
      NULL,
      NULL,
      NULL,
      0.484362,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.955985,
      2.478880,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.085959,
      NULL,
      1.558534,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.147594,
      0.863832,
      3.954529,
      1,
      1.733911,
      1,
      1.900051,
      NULL,
      0,
      NULL,
      0.505987,
      NULL,
      0,
      1.657161,
      0.355858,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '24134',
      NULL,
      '',
      1.794275,
      '',
      NULL,
      '',
      0,
      NULL,
      NULL,
      '',
      2.418594,
      2.267801,
      3.454240,
      2,
      3,
      NULL,
      NULL,
      3,
      NULL);
commit;
end;
/


