set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-6-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '3',
      NULL,
      NULL,
      '3434300',
      12,
      3,
      0,
      3,
      '301034',
      3.259079,
      ' 4-17-1991',
      9,
      NULL,
      0.675286,
      NULL,
      1.203084,
      0.538958,
      1,
      NULL,
      0,
      1.708018,
      0.000507,
      1.546125,
      0.106483,
      NULL,
      NULL,
      0.276105,
      0,
      0,
      1,
      NULL,
      1.780402,
      1.911857,
      1,
      4.683803,
      0.206326,
      1.472046,
      5,
      NULL,
      0,
      0.742943,
      1,
      NULL,
      NULL,
      NULL,
      1.592877,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.097074,
      1,
      0.594475,
      1,
      1.002441,
      1,
      1,
      0,
      0,
      0,
      0,
      0,
      0.257792,
      NULL,
      0.393222,
      1,
      1.097374,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      1,
      1.288829,
      1,
      0,
      1.492693,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.107794,
      0.159187,
      1,
      1.756360,
      NULL,
      NULL,
      4,
      NULL,
      1,
      NULL,
      NULL,
      7,
      1,
      5,
      NULL,
      3,
      1,
      0,
      2,
      1,
      NULL,
      NULL,
      1.353832,
      4.459184,
      4.033023,
      NULL,
      1.561981,
      7.355589,
      2.234772,
      NULL,
      5,
      NULL,
      2,
      1.756655,
      NULL,
      NULL,
      8.706773,
      0.519340,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.198731,
      1.762080,
      0,
      NULL,
      NULL,
      1.383735,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4.560474,
      2,
      0.829994,
      0.027455,
      1,
      3,
      1.943910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.229738,
      NULL,
      5.524483,
      0,
      2,
      0.503413,
      NULL,
      NULL,
      NULL,
      1,
      0.874133,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.797504,
      0.940201,
      0.612634,
      NULL,
      1.652327,
      1,
      1,
      2,
      0,
      0.311273,
      NULL,
      1,
      0.321772,
      1.550240,
      0.592948,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '22013',
      NULL,
      '',
      1,
      '',
      '',
      '',
      1.123783,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


