set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-6-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '1',
      NULL,
      NULL,
      '0440144',
      12.326820,
      3,
      1,
      NULL,
      NULL,
      1.372947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.436095,
      NULL,
      0,
      NULL,
      3,
      0.803340,
      0.194430,
      3.702316,
      1.752396,
      1,
      NULL,
      1,
      1,
      0,
      0.431655,
      0,
      0,
      NULL,
      1,
      5.157201,
      NULL,
      1,
      3.650042,
      0,
      0.807282,
      0,
      1,
      0.475325,
      NULL,
      NULL,
      0.056986,
      NULL,
      NULL,
      3.670896,
      0.849540,
      1.691682,
      3.810052,
      0.021207,
      0,
      0.620575,
      1.668968,
      0,
      1.827767,
      0.508012,
      NULL,
      0,
      1,
      0.419412,
      1.965841,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.483239,
      0.930948,
      1.101257,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.834384,
      0.318433,
      NULL,
      0.184145,
      1.778633,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      5.602699,
      1.829072,
      6,
      0,
      NULL,
      3,
      0,
      0.844978,
      NULL,
      0.504762,
      5.993553,
      1.853913,
      1.226842,
      NULL,
      6.986419,
      1.419432,
      2.389873,
      0.183706,
      3.752805,
      5.461870,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.948237,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.319256,
      2.909957,
      1.867185,
      1.432075,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.346840,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      2.120783,
      1.356473,
      0,
      2.236739,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.134151,
      1.237500,
      6.823114,
      2,
      5.726918,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.260537,
      1.664555,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.341958,
      NULL,
      0,
      2,
      NULL,
      3.577080,
      1.415798,
      0.582790,
      1,
      0,
      0.871887,
      0.672944,
      NULL,
      1,
      1,
      0,
      0.395020,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.686026,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.251384,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


