set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-6-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      15.047490,
      3,
      2.189762,
      3,
      '322404',
      1,
      '11-25-1987',
      7.789861,
      NULL,
      0.293197,
      NULL,
      3.049672,
      NULL,
      1,
      0.154087,
      NULL,
      0.014654,
      1.957641,
      1.943973,
      NULL,
      1.152477,
      3,
      0,
      1.461405,
      0.088855,
      0.214322,
      0.073771,
      1.446252,
      0.129468,
      0.092052,
      1,
      0.565238,
      1,
      6.140848,
      0,
      2.355363,
      0,
      1.124952,
      1,
      NULL,
      NULL,
      0.374652,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.379627,
      0.588226,
      3,
      NULL,
      0.929288,
      2,
      1,
      NULL,
      NULL,
      1.429775,
      0.179556,
      1,
      0,
      0.093921,
      0.703303,
      1,
      1,
      0.116150,
      NULL,
      0,
      1,
      4.355481,
      1,
      NULL,
      NULL,
      0.523569,
      NULL,
      NULL,
      1.472393,
      1,
      3,
      NULL,
      1.952754,
      0.465807,
      1.770940,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      0.908984,
      1.919785,
      0,
      0,
      1.686623,
      1,
      NULL,
      1,
      7,
      2,
      0.840117,
      9,
      0,
      7.302182,
      1,
      0.842368,
      1.098083,
      9,
      NULL,
      0.159087,
      3.966770,
      NULL,
      NULL,
      2.340339,
      7,
      8,
      7,
      NULL,
      3,
      NULL,
      6.553501,
      2,
      1.355390,
      17,
      6.489909,
      0.462227,
      0.151899,
      NULL,
      4,
      1.722242,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.916505,
      0,
      0,
      1,
      NULL,
      4.596295,
      NULL,
      0.736467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.097747,
      1.205036,
      4.121959,
      4,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.863730,
      NULL,
      3,
      2.851230,
      2.162924,
      3.378651,
      1.064592,
      NULL,
      0,
      2.881076,
      1,
      0.450711,
      1,
      1.039634,
      0,
      NULL,
      0.329535,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.136157,
      '43323',
      '',
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


