set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-7-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      '4044024',
      2,
      2,
      2.399038,
      1,
      '303123',
      1.412663,
      '11-26-1995',
      5.632866,
      NULL,
      1,
      NULL,
      1.195269,
      1,
      NULL,
      0.306064,
      0.199643,
      0,
      1.687989,
      0,
      NULL,
      0.669735,
      0,
      0.693227,
      5,
      2.825549,
      0,
      1.640319,
      8,
      1.223112,
      9,
      0,
      0,
      1,
      4.631974,
      0,
      3,
      0,
      0.474248,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      5,
      NULL,
      NULL,
      2.594294,
      0.444596,
      0,
      1.281544,
      3.722814,
      0,
      3,
      0,
      1.148968,
      NULL,
      0.740663,
      NULL,
      0.449737,
      1,
      NULL,
      0.688104,
      1.364096,
      0.719259,
      11.791644,
      1,
      2,
      2.369861,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.353838,
      3,
      0.488452,
      1,
      0,
      1.583398,
      1.471515,
      0.561925,
      1.659987,
      1,
      2,
      0.298249,
      1.242771,
      1.513802,
      NULL,
      1,
      NULL,
      1,
      0.961895,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      1,
      7.513497,
      NULL,
      1,
      0.041641,
      3.661657,
      1.997009,
      5,
      NULL,
      4,
      1.352580,
      11.287070,
      6.360656,
      NULL,
      7.132577,
      0,
      NULL,
      3.358127,
      6,
      NULL,
      0.040050,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      1,
      1,
      3,
      0.173148,
      0.431972,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      7.316107,
      NULL,
      3.172435,
      NULL,
      NULL,
      0.086023,
      0.054942,
      0,
      10.736767,
      2.045992,
      0,
      NULL,
      1,
      1.500480,
      1,
      1.491051,
      0.612248,
      NULL,
      1.911633,
      NULL,
      0,
      NULL,
      1.131973,
      NULL,
      NULL,
      0,
      7.418463,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.396432,
      3.997738,
      1,
      0.919988,
      0.173152,
      3.350785,
      2,
      1.392304,
      3.361607,
      2,
      2.619000,
      0.542832,
      1,
      NULL,
      1,
      1.754497,
      0.349408,
      1.733349,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '',
      '',
      0.529661,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


