set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-12-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '2',
      NULL,
      NULL,
      '2223424',
      22,
      NULL,
      3,
      2,
      '343314',
      2,
      ' 6-27-1974',
      21.554993,
      NULL,
      1,
      NULL,
      NULL,
      0.499943,
      NULL,
      0,
      0,
      1.753575,
      NULL,
      NULL,
      1,
      1.596292,
      7,
      0.296832,
      0.738874,
      0.380543,
      1,
      1,
      1.939021,
      0.783562,
      0.605355,
      5,
      0.059400,
      0.015518,
      NULL,
      0,
      5.985313,
      0.356481,
      2,
      0.163555,
      NULL,
      NULL,
      1.007428,
      NULL,
      NULL,
      6,
      1,
      NULL,
      NULL,
      1,
      1.264184,
      2.717062,
      0.428709,
      0.566568,
      3,
      0.863843,
      1,
      1.775931,
      NULL,
      0,
      NULL,
      0,
      0.469737,
      0,
      NULL,
      0,
      0.631443,
      1.026534,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.587435,
      NULL,
      1,
      1,
      1.762410,
      0,
      NULL,
      1,
      1.928030,
      0.476221,
      1.735857,
      0.181086,
      0,
      0.076976,
      NULL,
      0,
      0.718177,
      NULL,
      1.800851,
      1,
      NULL,
      1,
      3,
      0.169310,
      4,
      1,
      2.992817,
      4,
      5,
      2,
      0.703313,
      0.545943,
      0,
      0.457533,
      NULL,
      2,
      4.560746,
      NULL,
      2,
      5,
      NULL,
      9.241548,
      0.082623,
      0,
      9,
      0.022602,
      3,
      1.688548,
      0.800854,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0.830582,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.270567,
      NULL,
      NULL,
      NULL,
      1.019808,
      0.964947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.759469,
      1.032359,
      1.046276,
      NULL,
      NULL,
      NULL,
      0.438551,
      0,
      1.092166,
      3,
      1.637377,
      0,
      0.783019,
      NULL,
      NULL,
      NULL,
      NULL,
      2.788836,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.881234,
      1,
      2,
      1,
      NULL,
      NULL,
      1.320874,
      1.024414,
      NULL,
      0,
      1.324813,
      0,
      0,
      0.229288,
      1.874266,
      0,
      1.259208,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.227829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.388521,
      '01020',
      NULL,
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


