set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-12-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '2',
      NULL,
      NULL,
      '3323204',
      30,
      0,
      2,
      0,
      NULL,
      0,
      ' 4-27-1992',
      35,
      NULL,
      NULL,
      NULL,
      2.644521,
      1,
      1,
      0,
      0.380193,
      3,
      0,
      0,
      1,
      1,
      NULL,
      1.703695,
      0,
      1,
      1,
      0.582705,
      0,
      0.638836,
      1,
      NULL,
      0.330660,
      0.757090,
      NULL,
      NULL,
      4.102674,
      0.587609,
      0.279997,
      NULL,
      NULL,
      NULL,
      1.841378,
      NULL,
      NULL,
      0,
      2.147632,
      0,
      0.817131,
      1,
      1.550783,
      1,
      0,
      1,
      0,
      1.931987,
      0,
      1.604273,
      1.794076,
      0.378706,
      1,
      0,
      1.556367,
      1.557486,
      1.514098,
      1.506611,
      NULL,
      5,
      1,
      NULL,
      1,
      0.470998,
      NULL,
      NULL,
      1.366507,
      NULL,
      NULL,
      1.996670,
      0.240322,
      0,
      1,
      2.283290,
      NULL,
      1,
      0.718960,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.601583,
      0.651735,
      NULL,
      0.932805,
      NULL,
      1.376244,
      6.728512,
      1.874438,
      NULL,
      1.595641,
      NULL,
      2,
      0.150936,
      1,
      2.707492,
      0,
      2,
      1,
      0,
      3.167590,
      1.525030,
      1.701495,
      1,
      1,
      7,
      6.791483,
      2,
      NULL,
      2,
      8,
      NULL,
      19.011507,
      1.311538,
      2,
      0,
      NULL,
      2.211858,
      0.754583,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.170675,
      0,
      NULL,
      0,
      0,
      4,
      NULL,
      0.568197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.187676,
      1,
      0,
      0,
      3.275944,
      NULL,
      NULL,
      1.611289,
      0.376658,
      0.716902,
      NULL,
      NULL,
      1.907669,
      6,
      0.117386,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.424140,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.903151,
      3,
      0.002026,
      3,
      1,
      1,
      0,
      0,
      1,
      1.873893,
      0,
      1.649234,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      1.780241,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '',
      '',
      0.210292,
      '',
      '',
      '',
      1.933664,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


