set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-12-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '1',
      NULL,
      NULL,
      '1114031',
      37,
      0,
      0,
      2,
      '132212',
      2,
      ' 5-16-1993',
      10.338803,
      NULL,
      1.705518,
      NULL,
      2.176762,
      3.611983,
      NULL,
      0,
      NULL,
      2.260052,
      2,
      NULL,
      3.218212,
      NULL,
      5,
      0,
      1,
      0,
      1.778337,
      4.117900,
      1,
      1,
      1,
      1.132931,
      0.017280,
      0.824342,
      NULL,
      1,
      NULL,
      0.393831,
      2.603982,
      0,
      NULL,
      NULL,
      1.211968,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      0.528779,
      1.430872,
      3.331877,
      NULL,
      0.514619,
      NULL,
      1,
      1.923596,
      NULL,
      0,
      1.443825,
      0,
      NULL,
      0.210712,
      0,
      NULL,
      NULL,
      NULL,
      6.324299,
      1,
      1,
      2.609122,
      1,
      NULL,
      NULL,
      0.695090,
      NULL,
      NULL,
      1.839853,
      NULL,
      5,
      NULL,
      4,
      NULL,
      NULL,
      0.280259,
      NULL,
      1,
      0.392958,
      NULL,
      1,
      NULL,
      1.830172,
      0,
      0.814988,
      1.612418,
      0.318967,
      NULL,
      0,
      0,
      3,
      0,
      2.137213,
      0.050257,
      5,
      1.365153,
      3.775336,
      3.046598,
      0,
      0.652731,
      1,
      NULL,
      5.288501,
      1.860569,
      NULL,
      NULL,
      9.796156,
      5.746658,
      7,
      3,
      7,
      0.140012,
      4,
      1.706502,
      8,
      6.413477,
      NULL,
      NULL,
      0,
      3.792358,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.480597,
      1,
      NULL,
      1,
      0.305588,
      2.436989,
      1.999279,
      1.837992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.733814,
      NULL,
      NULL,
      0.509152,
      1.349720,
      3,
      NULL,
      2,
      NULL,
      NULL,
      3,
      7.730007,
      2.441206,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      8,
      5,
      1,
      2.343336,
      1.581241,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.577441,
      1.073763,
      1,
      NULL,
      2.238970,
      0.008350,
      2.867382,
      NULL,
      0.783048,
      1.981520,
      0,
      0.019215,
      NULL,
      1,
      1.407870,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.839999,
      '03132',
      '',
      '',
      0,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


