set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-7-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '4',
      NULL,
      NULL,
      '3240201',
      NULL,
      3,
      NULL,
      2,
      NULL,
      2,
      ' 2-29-1978',
      3,
      NULL,
      1.532317,
      NULL,
      1,
      3,
      0,
      0,
      0.147556,
      NULL,
      0,
      1,
      0,
      NULL,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.207111,
      1.860091,
      0,
      0,
      NULL,
      1,
      2,
      0,
      4.669855,
      1,
      1,
      0.113034,
      NULL,
      NULL,
      1.623573,
      NULL,
      NULL,
      1,
      1.125186,
      0,
      NULL,
      0.371006,
      NULL,
      3,
      1.027776,
      2.496782,
      0.640938,
      NULL,
      1.955125,
      1.134704,
      3.178259,
      NULL,
      2.944496,
      0.598880,
      0.755988,
      1,
      1.439470,
      0,
      1.732357,
      4,
      0,
      1,
      1.751481,
      1.003709,
      NULL,
      NULL,
      1.733451,
      NULL,
      NULL,
      1,
      0.731888,
      1,
      1,
      5,
      1.341880,
      NULL,
      NULL,
      0.378185,
      NULL,
      0.502785,
      0.683236,
      0.173610,
      NULL,
      1.246134,
      NULL,
      NULL,
      0.101266,
      0.429967,
      NULL,
      0.442719,
      1,
      NULL,
      1,
      5,
      0,
      3.983535,
      1,
      1.097498,
      0,
      1,
      NULL,
      NULL,
      NULL,
      5.624904,
      0.396095,
      1,
      2.636766,
      4.758712,
      1.895425,
      6,
      2,
      1.834231,
      8.341367,
      0,
      1.840519,
      2.495809,
      3.656348,
      1,
      0,
      NULL,
      3.891495,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      2,
      0,
      0,
      0.495492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      9,
      0,
      1.125966,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.901155,
      1.537510,
      0,
      1.590149,
      0,
      1,
      0.804814,
      NULL,
      NULL,
      0,
      3.206006,
      1.765198,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.700204,
      NULL,
      0,
      NULL,
      2.111815,
      3.270250,
      0.137130,
      0,
      2,
      1.352472,
      1.951802,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.985062,
      NULL,
      0,
      0.363093,
      1.133271,
      NULL,
      3.901629,
      1.586181,
      1.153011,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.879682,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '04211',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


