set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-7-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      '3001402',
      52,
      NULL,
      1,
      3,
      NULL,
      3.493681,
      ' 3- 8-1991',
      1.520032,
      NULL,
      0,
      NULL,
      1.016364,
      NULL,
      0,
      1.939804,
      0.324794,
      2,
      0,
      0,
      1,
      NULL,
      7,
      0,
      0,
      0,
      0.473301,
      NULL,
      1.865620,
      1,
      0,
      0,
      NULL,
      0.304637,
      2,
      NULL,
      0,
      0.086340,
      0.157987,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.200095,
      3.263318,
      0.894042,
      0.729279,
      1,
      NULL,
      0,
      NULL,
      1.226285,
      NULL,
      1.566687,
      NULL,
      NULL,
      1,
      1,
      0.080317,
      0,
      1,
      1,
      0,
      0.264069,
      0.917928,
      1,
      0,
      1.440122,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.440368,
      1,
      1,
      1.319206,
      3.486143,
      1.623226,
      1,
      0.917658,
      0.438297,
      NULL,
      0.610617,
      1.035117,
      NULL,
      NULL,
      1,
      0,
      0.155327,
      1.184824,
      0,
      NULL,
      0.072927,
      6,
      1.723194,
      NULL,
      2.240547,
      1.537659,
      NULL,
      0.606781,
      7.996981,
      1.591987,
      NULL,
      0.283156,
      NULL,
      1,
      1,
      1,
      NULL,
      0.675104,
      6.951255,
      NULL,
      1,
      3,
      2.511259,
      4.728144,
      11,
      3.156555,
      1,
      1,
      0,
      1.893040,
      1.447714,
      3.580502,
      1.532722,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.118995,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.933208,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.091596,
      1,
      NULL,
      1.071522,
      1,
      NULL,
      0.806294,
      NULL,
      NULL,
      NULL,
      1.838739,
      1.724570,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.166797,
      3.162189,
      NULL,
      1.023663,
      NULL,
      2.520761,
      NULL,
      NULL,
      0.174472,
      3.644416,
      1.950536,
      NULL,
      NULL,
      1,
      1.649216,
      1,
      0.138842,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '14041',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


