set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-8-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '3',
      NULL,
      NULL,
      NULL,
      39,
      6,
      0.677488,
      2,
      '044132',
      3.941075,
      ' 9-28-1975',
      24.049867,
      NULL,
      0.934651,
      NULL,
      5.476755,
      2.631051,
      1.114435,
      NULL,
      0.867412,
      2,
      0.823588,
      0,
      1.386941,
      NULL,
      7.863827,
      1.049842,
      NULL,
      0.192563,
      0,
      NULL,
      1.676010,
      NULL,
      0,
      1,
      NULL,
      1,
      3.627377,
      0,
      1,
      1.973614,
      0,
      0.340286,
      NULL,
      NULL,
      1.081422,
      NULL,
      NULL,
      2.096095,
      3,
      0,
      3.925330,
      0,
      1,
      3,
      2,
      NULL,
      1,
      2.189665,
      2,
      1,
      0.395442,
      1,
      1.645442,
      1,
      0,
      NULL,
      1,
      1,
      0,
      1.201193,
      0,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.569046,
      0.089865,
      1.729516,
      1,
      2.082589,
      1,
      2,
      0.760333,
      0,
      0.433500,
      1.661443,
      NULL,
      1.942603,
      1.212173,
      1,
      0,
      1.671400,
      0.484748,
      1.032733,
      NULL,
      0,
      4,
      NULL,
      NULL,
      1.171212,
      0.481457,
      0,
      1,
      3,
      1.976515,
      0.850934,
      2,
      NULL,
      NULL,
      4.296905,
      0.319116,
      4,
      4.752297,
      3,
      9,
      4.382320,
      0.958779,
      6.664831,
      11,
      1.249309,
      NULL,
      2,
      2,
      1.819200,
      0.721743,
      NULL,
      1,
      0.302806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.516925,
      NULL,
      0,
      0,
      1,
      0,
      0.745103,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      6.216064,
      1,
      1.016661,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.082659,
      0.754792,
      0,
      NULL,
      0.209209,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.207901,
      2,
      2.128964,
      1,
      3.196535,
      1,
      NULL,
      2.974948,
      NULL,
      0,
      NULL,
      NULL,
      1.868612,
      0,
      NULL,
      2.631032,
      NULL,
      0,
      0.798744,
      NULL,
      1,
      0,
      1,
      2.823622,
      1.145668,
      0.821324,
      0.340437,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '32340',
      '',
      '',
      0.055316,
      '',
      '',
      '',
      0.592914,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


