set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-12-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      NULL,
      NULL,
      '4443122',
      57.855549,
      1,
      NULL,
      3,
      '020213',
      3.429257,
      NULL,
      26.009912,
      NULL,
      0,
      NULL,
      1,
      0.435029,
      0.351400,
      0.295010,
      NULL,
      0.787873,
      1.798556,
      0.022267,
      0,
      1,
      7.936315,
      0.430395,
      0,
      0.760953,
      0.022624,
      0,
      3.171822,
      1.213528,
      NULL,
      1.238322,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      2.986264,
      3,
      NULL,
      0,
      1,
      1.716770,
      1.846248,
      0,
      0,
      1.748663,
      1.027022,
      0,
      0,
      0.814760,
      NULL,
      1.064907,
      0,
      0.633392,
      1.172954,
      0.374249,
      3.355155,
      NULL,
      1,
      0.883789,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.575741,
      1.293968,
      4.368624,
      1.329221,
      1.124733,
      1,
      1,
      0,
      0,
      1.401714,
      0.210901,
      NULL,
      0.618981,
      0,
      0.824149,
      1,
      1.396128,
      1,
      NULL,
      NULL,
      1.387628,
      0,
      0.461543,
      0,
      5,
      NULL,
      3.200672,
      NULL,
      1.267463,
      2,
      2,
      2.708053,
      NULL,
      0,
      0.453519,
      1,
      NULL,
      NULL,
      6,
      NULL,
      2.628657,
      0,
      8,
      0,
      0.825940,
      2.034506,
      1.714329,
      5,
      0.142477,
      1,
      1,
      0.245519,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.370462,
      0,
      0,
      NULL,
      1,
      0.244580,
      1.388716,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.389661,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.148275,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.866931,
      0,
      0.288491,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3.825272,
      1.168948,
      NULL,
      2,
      1.240795,
      0.356156,
      0,
      1.659585,
      0.853898,
      0.269761,
      1.612754,
      NULL,
      NULL,
      0.969874,
      0,
      0,
      1.936520,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '32141',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      0.262093,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


