set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-7-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      NULL,
      NULL,
      '1044111',
      43.452435,
      2,
      NULL,
      0,
      '110022',
      0.665680,
      NULL,
      18.602267,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.377461,
      NULL,
      0,
      NULL,
      1.919865,
      0,
      1.257113,
      4.395901,
      1.908326,
      NULL,
      2.123463,
      3,
      1,
      0.626092,
      1,
      1.613019,
      9.780679,
      1.170172,
      0.977356,
      7,
      1,
      5,
      0.674550,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      0,
      1,
      0.689078,
      3.593916,
      NULL,
      2.560870,
      1,
      0.106849,
      1.343893,
      0.894298,
      0,
      1,
      2.100929,
      1,
      0.117720,
      0,
      2,
      1,
      0,
      NULL,
      1,
      0,
      0,
      0.848441,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.081760,
      NULL,
      1.442174,
      1,
      2.121823,
      1.622794,
      0.709834,
      0.564375,
      0,
      1,
      NULL,
      NULL,
      1.499960,
      NULL,
      1.170799,
      0,
      0,
      1.245349,
      0.476715,
      NULL,
      1.674207,
      0.765512,
      1,
      0.950690,
      0,
      NULL,
      2.264277,
      0,
      2,
      0,
      2,
      2,
      0,
      NULL,
      5,
      1,
      NULL,
      NULL,
      3,
      NULL,
      3.441130,
      5,
      6.312003,
      NULL,
      7.657927,
      4.979509,
      NULL,
      0,
      0,
      1.058377,
      1.072342,
      3.079074,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1,
      NULL,
      2.694629,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.449097,
      1.397901,
      1.212879,
      1,
      0,
      NULL,
      0.143858,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      5,
      2,
      2,
      1,
      6.899053,
      1,
      NULL,
      NULL,
      1.772757,
      11,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.397154,
      2,
      2,
      0.512210,
      1.292721,
      1.884448,
      3.352712,
      3.643437,
      NULL,
      0.845926,
      0,
      NULL,
      NULL,
      1,
      1.129093,
      1.816545,
      1.025090,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      '',
      '',
      0.909042,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


