set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-7-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '3',
      NULL,
      NULL,
      '1104221',
      43.921404,
      1,
      NULL,
      1,
      NULL,
      3.206917,
      ' 0-19-1988',
      20,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.650292,
      2,
      1,
      1.464703,
      2,
      1,
      2,
      NULL,
      0,
      2,
      NULL,
      3.631299,
      3,
      NULL,
      NULL,
      8,
      NULL,
      0.794838,
      5.581481,
      NULL,
      1,
      0,
      0.595133,
      0.421705,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.762700,
      NULL,
      NULL,
      0.846371,
      NULL,
      3.791635,
      1.333320,
      1,
      NULL,
      2.705981,
      3.763462,
      3,
      NULL,
      1.184334,
      NULL,
      3,
      NULL,
      0.798952,
      0,
      NULL,
      0,
      6.701204,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      0.138226,
      NULL,
      NULL,
      NULL,
      1.704925,
      1,
      1.198819,
      5.869327,
      NULL,
      0,
      1.152031,
      5.818454,
      5.652840,
      3.699822,
      1,
      NULL,
      1.697256,
      0,
      1,
      1,
      0.254908,
      NULL,
      NULL,
      0.687452,
      NULL,
      NULL,
      0,
      2.054686,
      1,
      5,
      0.115620,
      3.360278,
      1,
      2.541211,
      4.604025,
      NULL,
      0,
      4.194692,
      1.312482,
      4,
      8.892769,
      NULL,
      4,
      1.930142,
      8,
      4.350498,
      7,
      10.799261,
      NULL,
      6,
      2,
      NULL,
      0,
      0,
      0,
      1.070023,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.356326,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.132211,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5.064256,
      NULL,
      NULL,
      3,
      1,
      1,
      NULL,
      1,
      0.738039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.876569,
      8,
      6.239098,
      2.627871,
      1,
      5,
      1.989845,
      NULL,
      NULL,
      0.762980,
      6.530310,
      0.669501,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2.942554,
      1,
      NULL,
      2.852033,
      3.288751,
      3.846815,
      1,
      2.494876,
      0,
      0,
      1.748981,
      NULL,
      0.890953,
      0,
      NULL,
      1,
      1,
      0.429246,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.998268,
      NULL,
      '',
      '',
      1.324228,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


