set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-12-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '3',
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      3,
      NULL,
      '001023',
      NULL,
      ' 2-21-1991',
      28.198306,
      NULL,
      1.686425,
      NULL,
      3,
      1.184621,
      1.717527,
      1.676705,
      0,
      2,
      1,
      0,
      1.127428,
      0.999891,
      2.301683,
      NULL,
      3,
      2.624748,
      2.857520,
      2,
      3,
      1,
      NULL,
      6,
      NULL,
      0.904337,
      1.455726,
      1,
      0,
      0.140609,
      3.522145,
      0,
      NULL,
      NULL,
      0.705611,
      NULL,
      NULL,
      5,
      6.704200,
      NULL,
      0.840467,
      1.303812,
      2.645662,
      0.866144,
      0.365214,
      0.976290,
      3,
      1,
      NULL,
      3.932495,
      NULL,
      1.264809,
      0.216712,
      1,
      NULL,
      0.170168,
      1,
      NULL,
      0.802463,
      4.398862,
      0,
      1,
      1.259371,
      NULL,
      NULL,
      NULL,
      1.117624,
      NULL,
      NULL,
      0,
      1.121074,
      NULL,
      0,
      0.315027,
      1.433514,
      1.360436,
      0.710797,
      NULL,
      1.387511,
      NULL,
      NULL,
      1.546702,
      0,
      1,
      0.195283,
      NULL,
      1,
      1.817634,
      NULL,
      NULL,
      4.582636,
      6.958938,
      1.551190,
      1,
      NULL,
      2.453560,
      0,
      0,
      1.777489,
      NULL,
      NULL,
      NULL,
      0,
      2.714803,
      NULL,
      NULL,
      3.741795,
      0.069268,
      9.329517,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.145111,
      0,
      NULL,
      3.848578,
      0,
      0.109436,
      5,
      0.228973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.975545,
      1,
      1,
      0,
      1.208049,
      1.303331,
      1.797019,
      0.875281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.480131,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      4,
      NULL,
      5.200681,
      NULL,
      5,
      1.339010,
      NULL,
      NULL,
      0.313086,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.259309,
      2,
      0.853119,
      0,
      2.499087,
      1,
      1.747245,
      0,
      3.622049,
      NULL,
      1.661351,
      1.080114,
      0.968777,
      0.688650,
      1,
      0,
      1,
      0.567864,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.174992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '33303',
      '',
      '',
      0.013169,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


