set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-6-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '4',
      NULL,
      NULL,
      '2204431',
      NULL,
      4,
      0,
      2,
      NULL,
      2.973603,
      ' 4-11-1999',
      18.545324,
      NULL,
      0.744659,
      NULL,
      2,
      NULL,
      1.639921,
      0,
      NULL,
      2,
      NULL,
      NULL,
      1,
      0.031216,
      4.639105,
      0.140916,
      1,
      NULL,
      0.531270,
      0,
      1.204918,
      NULL,
      3.623721,
      NULL,
      1.607841,
      0,
      4,
      1,
      0,
      1,
      0.278142,
      0.843560,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.179945,
      0,
      NULL,
      NULL,
      0,
      0,
      0.804918,
      0,
      0,
      1.678905,
      3,
      0.625385,
      0,
      0.531232,
      1,
      1,
      NULL,
      1,
      0,
      1.546376,
      0,
      0.445216,
      4.595431,
      0,
      1,
      0.721196,
      1.659286,
      NULL,
      NULL,
      0.528457,
      NULL,
      NULL,
      1.423924,
      1.128161,
      1,
      1.453742,
      NULL,
      1.023580,
      1,
      1,
      0.731282,
      1,
      0.260300,
      0.880606,
      0.681206,
      NULL,
      NULL,
      0,
      1.840182,
      1.226498,
      NULL,
      NULL,
      1,
      4.632137,
      1,
      NULL,
      1,
      0,
      3.955618,
      1,
      2.079156,
      0.932595,
      3.217181,
      NULL,
      NULL,
      2.815720,
      NULL,
      0.385760,
      1.359651,
      7.184539,
      9,
      NULL,
      0,
      0.138226,
      0,
      2.354697,
      0.508217,
      0.959466,
      NULL,
      NULL,
      0.872069,
      NULL,
      NULL,
      5.191140,
      0.036993,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.432843,
      1.522081,
      1,
      NULL,
      1,
      1.181873,
      NULL,
      1.340147,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.935407,
      1.138604,
      1,
      2.837852,
      5.314064,
      2.034143,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.935505,
      0,
      2,
      0.601305,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.540437,
      0.819466,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      2.544847,
      3,
      1,
      1.544906,
      NULL,
      NULL,
      0,
      1.241553,
      0,
      0,
      0,
      1,
      1,
      1,
      0,
      1.145168,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.177350,
      '33024',
      '',
      NULL,
      1.915972,
      NULL,
      '',
      '',
      1.373709,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


