set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-12-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '3',
      NULL,
      NULL,
      '4243030',
      NULL,
      NULL,
      3.665366,
      3,
      '243121',
      0,
      ' 7-27-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      1.026025,
      2.879017,
      1,
      0.435449,
      0.581872,
      2,
      0,
      0,
      3,
      1.411653,
      4.884939,
      1.021735,
      1.833984,
      1.394936,
      0.891986,
      0,
      1.180360,
      NULL,
      4.802694,
      1.215231,
      NULL,
      0,
      NULL,
      1,
      2,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.671052,
      5.835041,
      1.355782,
      NULL,
      0.940984,
      1,
      0,
      0.306301,
      1.513552,
      NULL,
      0.861676,
      2,
      0.317976,
      3.609623,
      0,
      0.848331,
      1,
      NULL,
      0,
      NULL,
      0.081174,
      0.489451,
      4,
      1,
      NULL,
      0.323759,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.516320,
      1,
      0.497736,
      0.300723,
      NULL,
      NULL,
      1,
      1.518687,
      0,
      NULL,
      1,
      0,
      1.709790,
      0.230259,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1,
      1.871736,
      NULL,
      1.301284,
      1.440702,
      1.877598,
      2.447909,
      5.277067,
      1,
      1.964161,
      4.878745,
      1.901271,
      NULL,
      4.690730,
      NULL,
      7.211345,
      3.704947,
      0,
      5,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.625249,
      0,
      1,
      1.473814,
      1.980922,
      0.106942,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.295189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.697319,
      0.593045,
      1.281315,
      NULL,
      NULL,
      NULL,
      0.447270,
      0.539891,
      NULL,
      NULL,
      1.478932,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.484345,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.738557,
      NULL,
      1.713496,
      NULL,
      2,
      1,
      2,
      0,
      1,
      3,
      NULL,
      NULL,
      0,
      NULL,
      1.822028,
      0,
      0.628741,
      0.517151,
      1,
      1.745670,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.906534,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '02421',
      '',
      '',
      0,
      '',
      '',
      '',
      0.904107,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


