set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-1-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '2',
      NULL,
      NULL,
      '3221242',
      42.798246,
      4,
      1,
      3,
      '111443',
      0.703938,
      '11-22-1979',
      2.276029,
      NULL,
      NULL,
      NULL,
      0.243802,
      NULL,
      1.576310,
      1.130545,
      0,
      0,
      0.321165,
      1.414383,
      3.093767,
      NULL,
      5,
      NULL,
      1,
      0,
      0,
      1,
      0,
      NULL,
      0.136613,
      1,
      1,
      0.331286,
      1.054602,
      0,
      4,
      1,
      1.342626,
      0,
      NULL,
      NULL,
      0.388373,
      NULL,
      NULL,
      7.058567,
      NULL,
      1,
      0,
      NULL,
      1.757342,
      0.944755,
      0.822868,
      0,
      1,
      0.380802,
      0.691812,
      1,
      1.118218,
      0.181633,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.580893,
      3.594176,
      1.607044,
      2,
      0,
      1.074243,
      0.618685,
      1.699923,
      0.183199,
      NULL,
      1,
      0,
      0,
      0,
      0,
      1.679571,
      NULL,
      0.870690,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1.557800,
      1,
      1,
      0.284124,
      2.169495,
      1.392298,
      3.584983,
      2,
      0,
      0.936115,
      2,
      0,
      1.399334,
      7,
      5,
      1,
      5,
      NULL,
      6.444372,
      8.548600,
      1,
      1,
      1,
      2,
      0.134373,
      NULL,
      NULL,
      4,
      1.407654,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.025256,
      NULL,
      4.091004,
      1.187078,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.836275,
      0,
      0.381267,
      NULL,
      NULL,
      NULL,
      1.747200,
      0,
      5,
      NULL,
      2,
      1,
      1.552963,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.435073,
      3.814959,
      1,
      0.913763,
      2,
      NULL,
      1.736677,
      0.443233,
      0,
      1,
      1.801310,
      1,
      1.425578,
      NULL,
      1.481564,
      0.927726,
      0.290088,
      0.601559,
      NULL,
      1.231241,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.446484,
      NULL,
      '',
      '',
      0.114004,
      NULL,
      '',
      NULL,
      0.754876,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


