set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-6-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '2',
      NULL,
      NULL,
      '1114140',
      79,
      4,
      3.881876,
      NULL,
      '211004',
      2.307655,
      ' 1-19-1991',
      NULL,
      NULL,
      0.142388,
      NULL,
      1.554479,
      NULL,
      1,
      1,
      0.664227,
      0.786047,
      NULL,
      0,
      2,
      0,
      0.716776,
      0.787831,
      NULL,
      1.479276,
      1,
      NULL,
      NULL,
      1,
      3.165027,
      1.622826,
      0,
      2,
      NULL,
      NULL,
      1,
      1,
      1.292039,
      1.163508,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6.391825,
      0,
      1.987460,
      2.898219,
      1,
      1,
      3.236618,
      2.255893,
      1.045833,
      3.477452,
      1.265167,
      3,
      0.362225,
      2,
      0.633826,
      3.745102,
      1,
      0.287578,
      1,
      0.420241,
      0,
      0,
      NULL,
      NULL,
      1,
      0.416509,
      1.899215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.071427,
      0.844137,
      0.810077,
      1.970005,
      NULL,
      1.061749,
      0.009510,
      0.365217,
      0,
      1.322747,
      1.196726,
      0,
      1.482165,
      NULL,
      1,
      0,
      0,
      1,
      0.352608,
      NULL,
      NULL,
      2.846367,
      0,
      NULL,
      0,
      1.003704,
      0,
      1.795054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.621761,
      1,
      NULL,
      3.660222,
      3.221382,
      NULL,
      NULL,
      NULL,
      3.113210,
      7,
      6.418233,
      0,
      0.059587,
      0,
      1,
      NULL,
      NULL,
      5.442100,
      0.247413,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.838946,
      NULL,
      0,
      0,
      1.156364,
      NULL,
      0,
      0.424162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.112558,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.944304,
      3.257698,
      2,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.648975,
      NULL,
      0.071307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.022591,
      1,
      NULL,
      1,
      0,
      0.271188,
      0.503756,
      NULL,
      1,
      1.273908,
      1,
      0,
      1,
      0,
      NULL,
      0.281266,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '24432',
      '',
      NULL,
      0,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


