set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-1-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '2',
      NULL,
      NULL,
      '0440014',
      NULL,
      6,
      2.358432,
      NULL,
      '030311',
      2,
      ' 1-14-1995',
      38,
      NULL,
      1,
      NULL,
      3.298244,
      NULL,
      NULL,
      0,
      1,
      2,
      0,
      0,
      0,
      0.522640,
      3.076126,
      1.239368,
      NULL,
      0,
      0.404615,
      3,
      5.705516,
      1.380399,
      0.365831,
      0.079636,
      1.560183,
      NULL,
      2,
      0,
      2,
      NULL,
      NULL,
      0.981496,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.777534,
      1.481033,
      0,
      0.551317,
      0.567889,
      0.951528,
      0.118982,
      0,
      NULL,
      0.120569,
      0.471736,
      1,
      NULL,
      1,
      0,
      0.925844,
      1.947050,
      1,
      1,
      1,
      0.923831,
      0.986895,
      3,
      0,
      0,
      NULL,
      0.865045,
      NULL,
      NULL,
      0.733554,
      NULL,
      NULL,
      0,
      0,
      1.829589,
      1.958852,
      NULL,
      0,
      0.968220,
      1,
      NULL,
      1.814993,
      0,
      1.747790,
      1.297358,
      0,
      NULL,
      0.847166,
      NULL,
      NULL,
      1,
      NULL,
      1.913430,
      3,
      1,
      NULL,
      1.627093,
      0,
      1.645913,
      0,
      3,
      3.484180,
      NULL,
      NULL,
      1.241252,
      1.060297,
      3,
      NULL,
      0.278359,
      3,
      6,
      7.968838,
      3.512181,
      NULL,
      2.394730,
      8,
      6,
      1.954806,
      NULL,
      3,
      0.396650,
      NULL,
      NULL,
      2,
      1.900522,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.009043,
      0,
      0,
      1,
      0.921479,
      NULL,
      0.855176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.635298,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      6.639374,
      1.533554,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.246173,
      2.900316,
      3,
      NULL,
      3.554590,
      2.371538,
      0,
      1,
      1,
      0,
      0,
      0,
      0,
      NULL,
      1,
      1,
      0.036662,
      NULL,
      1.926120,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '31112',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1.398154,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


