set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-5-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      '0422001',
      198.784554,
      NULL,
      0,
      3,
      NULL,
      2.008978,
      NULL,
      37,
      NULL,
      1,
      NULL,
      1.903519,
      2,
      1.375395,
      0.231371,
      1.565847,
      NULL,
      1.386342,
      1,
      1,
      0,
      2.309733,
      0,
      5,
      NULL,
      1.921449,
      5.014298,
      5,
      6.762224,
      4.790377,
      0,
      1,
      NULL,
      4.744336,
      1,
      2.133226,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      2.758185,
      1,
      NULL,
      1.332567,
      2,
      0,
      1.658412,
      1,
      NULL,
      0,
      3.488233,
      0,
      1.190655,
      3,
      0.905875,
      1,
      1.690393,
      2.623937,
      1.762382,
      7.344158,
      10.058530,
      0,
      2,
      4,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.574531,
      1,
      NULL,
      NULL,
      0.635277,
      0,
      0,
      1.384929,
      1,
      1.466694,
      NULL,
      1.112232,
      NULL,
      NULL,
      0,
      0,
      0.104447,
      0,
      NULL,
      1.228287,
      0,
      1.156253,
      3.128074,
      0,
      1,
      NULL,
      NULL,
      5.204177,
      1.421096,
      4,
      0,
      0.541314,
      1.471077,
      5.728530,
      1.753614,
      1.942710,
      2.401393,
      6.495951,
      6,
      5.331726,
      NULL,
      7,
      1,
      0.125051,
      NULL,
      NULL,
      1,
      3,
      1,
      NULL,
      1.271793,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.796106,
      NULL,
      NULL,
      NULL,
      1.066273,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.097864,
      NULL,
      8.752051,
      3.867620,
      NULL,
      0.154181,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2.208146,
      1,
      NULL,
      1.477233,
      NULL,
      1,
      3,
      5.223621,
      4.376340,
      0,
      NULL,
      1.205431,
      NULL,
      NULL,
      NULL,
      2.570813,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.510010,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1.538770,
      2.031941,
      NULL,
      0.348623,
      1,
      0,
      0.054004,
      0.497619,
      NULL,
      2,
      1.013889,
      0.597528,
      0.575641,
      1,
      NULL,
      NULL,
      2.008618,
      NULL,
      0,
      1.009015,
      1.253098,
      1,
      0.395259,
      0.189867,
      1,
      NULL,
      1.705092,
      0,
      1,
      0,
      1.067983,
      1.911870,
      1.755256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      '42142',
      '24000',
      NULL,
      0,
      NULL,
      '',
      '',
      1.884267,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


