set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-12-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      8.376249,
      '1032302',
      67.904273,
      NULL,
      3.882888,
      1,
      '000024',
      3.905157,
      NULL,
      25.290253,
      47.783181,
      1.197827,
      NULL,
      0.140429,
      1.522309,
      1,
      1.213768,
      1.718514,
      1.939496,
      0,
      NULL,
      3,
      1,
      0.122772,
      0,
      NULL,
      0,
      3.949397,
      NULL,
      NULL,
      0,
      1.481954,
      1.690117,
      0.534794,
      1,
      1,
      1,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      1.081605,
      NULL,
      NULL,
      2.774727,
      0.646038,
      1,
      0.990166,
      1,
      1.026858,
      1.214759,
      0.639737,
      1,
      0.095866,
      1,
      0,
      1,
      0,
      0.133893,
      0,
      1,
      1.978829,
      NULL,
      0.854809,
      NULL,
      1.289405,
      2.113144,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.472997,
      NULL,
      1,
      0.896001,
      NULL,
      1,
      1,
      1.375170,
      1.374519,
      1,
      0,
      1.091755,
      1.117172,
      1.000858,
      0,
      0,
      0,
      NULL,
      NULL,
      1.643913,
      1.384043,
      NULL,
      1.453755,
      1.900915,
      NULL,
      0.252527,
      4.476662,
      1.936429,
      0,
      0,
      NULL,
      1.215203,
      3,
      NULL,
      0.667634,
      9.071188,
      8,
      1.060554,
      0,
      2.821256,
      3.656313,
      2,
      NULL,
      2.933795,
      NULL,
      0.291379,
      0.661083,
      NULL,
      NULL,
      3.960626,
      0.213400,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1.937920,
      0.928851,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.135415,
      2.366159,
      0.197742,
      0.471785,
      NULL,
      2,
      1,
      1.115893,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.811876,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.272283,
      2.674907,
      1,
      0,
      0.399072,
      2,
      1,
      1.408595,
      1,
      1,
      0,
      1,
      1.236815,
      1.176089,
      NULL,
      1,
      1.911717,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.157737,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '03034',
      '14113',
      '',
      1.411439,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      5.732865,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


