set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-5-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '031',
      NULL,
      NULL,
      14,
      '4104044',
      166,
      6,
      NULL,
      1,
      '222100',
      NULL,
      NULL,
      6.831554,
      35.070082,
      1.910400,
      NULL,
      0.496448,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0.482895,
      2,
      1,
      4.553176,
      1.082372,
      NULL,
      NULL,
      1.015296,
      1.228215,
      0,
      1.513510,
      3.580575,
      0,
      0,
      1,
      NULL,
      0,
      1.414808,
      0,
      NULL,
      1.469542,
      NULL,
      NULL,
      0.817290,
      NULL,
      NULL,
      2,
      NULL,
      1.453506,
      0.099741,
      0.184606,
      0,
      3.463753,
      1,
      0,
      NULL,
      2.760428,
      1.548409,
      NULL,
      2.245152,
      0,
      3.557870,
      1.402156,
      1.590577,
      1,
      NULL,
      2,
      NULL,
      0,
      1,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.823488,
      NULL,
      1,
      0,
      NULL,
      1,
      1.146072,
      NULL,
      0.711937,
      0,
      0.833898,
      1,
      0.234976,
      1,
      1.313597,
      1.260044,
      1.049245,
      0,
      0,
      NULL,
      0,
      1,
      0.756413,
      1.749283,
      0,
      1,
      0.996372,
      1,
      NULL,
      NULL,
      2,
      1,
      0,
      1,
      5,
      1.691157,
      4.322829,
      7,
      0.695191,
      0.578015,
      NULL,
      0.135155,
      4.486465,
      NULL,
      9,
      3.488051,
      NULL,
      4,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.409185,
      1,
      0,
      1,
      0.363053,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.824046,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      8,
      NULL,
      6,
      0,
      2.878792,
      1,
      NULL,
      NULL,
      1,
      10.960704,
      1.337097,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.930489,
      NULL,
      0.824961,
      1.954279,
      1.823374,
      1.422077,
      1.299665,
      0,
      0,
      3.663938,
      1.409898,
      NULL,
      1,
      1,
      0,
      1,
      1.662959,
      1,
      1.427911,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.876336,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.852220,
      '10201',
      '24201',
      '',
      1.870083,
      '',
      '',
      '',
      0.035568,
      '',
      '',
      NULL,
      4.154853,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


