set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-11-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '242',
      '14',
      30,
      14.340239,
      '3140423',
      11.689432,
      2,
      3,
      3,
      NULL,
      4.619007,
      '10- 5-1989',
      22.556782,
      61.618763,
      0,
      NULL,
      NULL,
      3,
      0.428400,
      NULL,
      1,
      0.679582,
      0,
      0.975376,
      2.630642,
      0,
      4,
      0.463249,
      1,
      1.835348,
      1.260148,
      1,
      7.231498,
      1.441395,
      3.281930,
      0,
      1,
      NULL,
      1,
      0,
      3.431491,
      1.343108,
      0,
      0.684839,
      NULL,
      NULL,
      0.945754,
      NULL,
      NULL,
      4,
      0,
      0,
      2,
      0.136298,
      0,
      2.859880,
      1.271030,
      2,
      2,
      2,
      NULL,
      1.058724,
      0.570761,
      0.500893,
      0,
      1.764696,
      0.458718,
      0,
      1,
      NULL,
      0,
      1.703229,
      NULL,
      0,
      1.410673,
      1,
      NULL,
      NULL,
      0.786322,
      NULL,
      NULL,
      NULL,
      0,
      1.351209,
      0,
      NULL,
      0,
      0,
      NULL,
      0.045213,
      NULL,
      1,
      0.414610,
      1.222722,
      1,
      0,
      0.720033,
      NULL,
      0,
      0.022550,
      NULL,
      1,
      0.834646,
      0,
      0,
      1.800804,
      1.285959,
      0,
      1,
      2,
      0,
      2.665001,
      7.020188,
      2.320213,
      1,
      0,
      0.740644,
      NULL,
      NULL,
      0.300928,
      4,
      0,
      8.940310,
      2,
      5.376231,
      NULL,
      0,
      6,
      1.949581,
      NULL,
      NULL,
      NULL,
      3,
      0.179877,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.813133,
      1,
      1,
      0.916731,
      0.882088,
      0.577248,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5.449924,
      0.199553,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.953154,
      1,
      NULL,
      NULL,
      1.031991,
      1,
      3,
      1.532055,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.270988,
      1,
      2,
      0,
      1.521929,
      2.888003,
      0.833591,
      NULL,
      3,
      1,
      0.412230,
      1.673597,
      0,
      0,
      0,
      0,
      0.917805,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.342030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.904458,
      '11414',
      '22100',
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


