set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-5-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '434',
      '34',
      31.721139,
      7,
      '4202221',
      27,
      3,
      3,
      2,
      '300140',
      5,
      NULL,
      6,
      32.950289,
      0.369432,
      NULL,
      0,
      NULL,
      1.502255,
      0,
      NULL,
      1.943520,
      1,
      1,
      1,
      1,
      NULL,
      1.605990,
      1.729903,
      3,
      5,
      0.378586,
      NULL,
      3.059879,
      6,
      NULL,
      0.445394,
      1,
      6.273906,
      0,
      0,
      1.830003,
      2.238891,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.510733,
      1,
      2,
      NULL,
      1,
      0,
      0.020419,
      NULL,
      NULL,
      1.797209,
      0.640824,
      0,
      NULL,
      0,
      2.280861,
      NULL,
      0,
      1,
      1.568025,
      1,
      0.191054,
      2.751566,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.832507,
      NULL,
      NULL,
      0,
      1,
      0.140915,
      1,
      1,
      1.477307,
      0,
      NULL,
      0,
      0,
      0.243757,
      1.593702,
      1.786024,
      1.998895,
      1.401952,
      0,
      NULL,
      0.201094,
      1.921752,
      NULL,
      0,
      0.699812,
      1,
      0.167953,
      1.415808,
      0.791977,
      0,
      0.903937,
      NULL,
      5,
      5,
      1,
      0.424173,
      1.868576,
      NULL,
      NULL,
      1,
      4,
      8,
      0,
      5.502264,
      9.544850,
      2.761317,
      NULL,
      0,
      2.444400,
      2.126910,
      0.493863,
      1,
      0.944931,
      1.225328,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.633192,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      1.624358,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.499574,
      NULL,
      3.191322,
      2.279566,
      0,
      1.440519,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.949768,
      2.280518,
      1.545840,
      NULL,
      NULL,
      NULL,
      0.473721,
      1,
      6,
      4.270570,
      2,
      0,
      NULL,
      1.816654,
      NULL,
      NULL,
      0,
      0.380500,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.003115,
      NULL,
      1.616162,
      3,
      1,
      3.621863,
      NULL,
      0.717281,
      2,
      1.349021,
      1,
      NULL,
      1.317843,
      0.112269,
      0,
      0.697297,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4.422068,
      '20104',
      '14430',
      '',
      1,
      '',
      NULL,
      '',
      0,
      NULL,
      '',
      '',
      0.973072,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


