set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-5-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '203',
      NULL,
      49,
      25,
      NULL,
      97,
      NULL,
      0,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.549093,
      1,
      1,
      0.666841,
      1.482043,
      NULL,
      1,
      1,
      1.691850,
      1,
      2.341434,
      1.913006,
      1,
      2.358324,
      2,
      1,
      NULL,
      1.291578,
      3,
      0,
      0.240209,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.185587,
      1,
      0,
      NULL,
      NULL,
      0.320408,
      1,
      NULL,
      2,
      3.392171,
      1.056683,
      0,
      0,
      0.258632,
      NULL,
      NULL,
      0.260668,
      0,
      NULL,
      1,
      5,
      0,
      0,
      NULL,
      1.843552,
      NULL,
      NULL,
      0.299753,
      NULL,
      NULL,
      1,
      0,
      1.758336,
      1.054128,
      1,
      1,
      0.783660,
      NULL,
      0.218918,
      0.055977,
      0,
      1.852082,
      0,
      NULL,
      0,
      0.152311,
      0.396184,
      1.159164,
      NULL,
      NULL,
      0,
      NULL,
      0.012828,
      1,
      0.670442,
      1.443515,
      0.689110,
      0,
      2.141089,
      6.282214,
      0,
      4,
      1.357336,
      0.261683,
      5.798019,
      1.921999,
      3.212525,
      6.175255,
      NULL,
      NULL,
      5,
      5.629195,
      4,
      4.891715,
      6.291101,
      1,
      0,
      5,
      NULL,
      NULL,
      NULL,
      1.468583,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      2,
      1.186810,
      0.333713,
      0.845624,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.042197,
      NULL,
      6.136958,
      2,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6,
      2.348721,
      1.218870,
      0,
      9,
      0.498588,
      NULL,
      NULL,
      NULL,
      NULL,
      0.435933,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.086186,
      1.147188,
      1.140193,
      0,
      1,
      1,
      3,
      NULL,
      0,
      3,
      1.304496,
      0,
      0.110166,
      1,
      NULL,
      0.886046,
      0,
      1,
      1.241206,
      0.511599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.528165,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      '42340',
      '43033',
      '',
      1,
      '',
      NULL,
      '',
      1.438694,
      '',
      '',
      '',
      NULL,
      2.043176,
      1.922562,
      NULL,
      2.818046,
      NULL,
      3,
      NULL,
      0.701087);
commit;
end;
/


