set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-5-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '222',
      NULL,
      24.072851,
      34.537657,
      '2142442',
      1.372194,
      4,
      NULL,
      3,
      '021233',
      5,
      ' 2-16-1994',
      47,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0.550881,
      0,
      1,
      1.309640,
      1,
      0,
      3.312730,
      0.381080,
      5.120618,
      NULL,
      1.660801,
      2,
      NULL,
      1,
      1.145952,
      0,
      3,
      0,
      1.875241,
      NULL,
      NULL,
      0,
      2.813223,
      0,
      0.612794,
      NULL,
      NULL,
      NULL,
      1.754616,
      NULL,
      NULL,
      4.011031,
      0,
      NULL,
      0.543378,
      1.347958,
      1,
      1,
      0.932390,
      1.386764,
      NULL,
      0.177024,
      1,
      3,
      1,
      0,
      1.723123,
      1,
      1.118798,
      1.735113,
      0,
      0.985592,
      NULL,
      3.270546,
      NULL,
      0,
      1.961622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.962228,
      1.011883,
      0.579521,
      0,
      1,
      0,
      0,
      1,
      1.646788,
      0,
      0.343445,
      1,
      0.891067,
      1,
      NULL,
      1.193926,
      1,
      1,
      NULL,
      1.849870,
      NULL,
      NULL,
      NULL,
      0,
      0.301728,
      0.951825,
      NULL,
      1.387422,
      2.460592,
      7.881672,
      0,
      0.069769,
      1,
      0.343917,
      0.128008,
      0.645228,
      5.248547,
      3.687581,
      6,
      6.214820,
      11,
      1,
      NULL,
      9.071109,
      0,
      5,
      3.908359,
      1,
      NULL,
      NULL,
      NULL,
      0.131015,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.028036,
      NULL,
      NULL,
      NULL,
      0,
      1.298845,
      0.877108,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.853451,
      NULL,
      NULL,
      2.883164,
      1,
      0.127866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.449350,
      2,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      8,
      NULL,
      2,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1.099311,
      0.424018,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      0.025103,
      1,
      0.687746,
      2,
      2,
      1,
      2,
      3,
      0,
      NULL,
      1.473545,
      0.921718,
      0.230259,
      NULL,
      0.810021,
      1,
      1.574659,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      '41300',
      '23403',
      NULL,
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      0.878553,
      1.445099,
      NULL,
      NULL,
      1.508531,
      2,
      3.946773,
      3);
commit;
end;
/


