set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-11-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      7,
      '4023104',
      217,
      NULL,
      0,
      0,
      '303134',
      0,
      ' 5-17-1999',
      19,
      59,
      0.236694,
      NULL,
      2,
      NULL,
      1,
      0.620132,
      NULL,
      0.487213,
      NULL,
      0,
      NULL,
      0.996902,
      3,
      1,
      NULL,
      1.054545,
      0.615592,
      NULL,
      1,
      2.732496,
      4,
      0,
      1,
      0,
      3.500098,
      0,
      0,
      0.988129,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.398910,
      NULL,
      0,
      0.266080,
      1.360378,
      1.565152,
      1,
      NULL,
      0.319014,
      1,
      NULL,
      1,
      0.208710,
      NULL,
      0.324403,
      NULL,
      3.557413,
      0,
      1.873377,
      0.956916,
      NULL,
      0,
      0.380221,
      NULL,
      1,
      2,
      1,
      0.947910,
      NULL,
      NULL,
      0.609404,
      0.599540,
      0,
      0.360080,
      1,
      0.407099,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1.177907,
      0.336013,
      1,
      1,
      0.092479,
      0,
      1.510363,
      0,
      0.612885,
      NULL,
      0.699950,
      1.004731,
      1.659038,
      NULL,
      1,
      0.721552,
      0,
      0,
      3,
      5.984208,
      NULL,
      1.374783,
      1.521501,
      NULL,
      NULL,
      1,
      0,
      6.115424,
      NULL,
      6.799261,
      10,
      10,
      3,
      4.828573,
      2.595958,
      4,
      3.730967,
      3.563822,
      1,
      NULL,
      NULL,
      3.369066,
      1.385879,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.090331,
      NULL,
      1,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      0,
      2,
      0.368071,
      0.109811,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.005365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.691073,
      1.733334,
      7,
      5,
      1,
      2,
      NULL,
      1.341546,
      NULL,
      NULL,
      0.996489,
      8,
      NULL,
      0.243899,
      2,
      0.484604,
      7,
      1,
      1.670053,
      NULL,
      0.373129,
      0.480835,
      0.678328,
      2.389431,
      NULL,
      0,
      2,
      0,
      1.080930,
      0.841621,
      1.710078,
      0.533576,
      1,
      1,
      0.175446,
      1.828657,
      1,
      1,
      0.105609,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '13014',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      4.006684,
      3,
      1.813084,
      0.370326,
      NULL,
      0.781590,
      0,
      3.797104,
      NULL);
commit;
end;
/


