set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-5-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '130',
      '41410213',
      54.661156,
      NULL,
      '1033432',
      283,
      NULL,
      3.909271,
      2,
      NULL,
      3,
      ' 1- 4-1992',
      NULL,
      6.406606,
      NULL,
      NULL,
      0.948548,
      3.422427,
      0,
      1.188981,
      0.398653,
      0,
      NULL,
      0.478649,
      3,
      0.962100,
      4.892944,
      1.447117,
      0.785154,
      NULL,
      0,
      1,
      2,
      0.701763,
      5.650261,
      NULL,
      1.666546,
      1.983627,
      NULL,
      0,
      0,
      0.177107,
      1,
      1.825972,
      NULL,
      NULL,
      1.384893,
      NULL,
      NULL,
      NULL,
      0.726315,
      NULL,
      0,
      1,
      1.565747,
      NULL,
      1.235079,
      1,
      1,
      0,
      1,
      1,
      1.571318,
      0,
      2.127766,
      0.875106,
      1,
      0.772836,
      1.983539,
      2,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.867697,
      0,
      0,
      1.415497,
      1.456587,
      1.416022,
      1,
      0.494948,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.671774,
      1,
      0.685546,
      NULL,
      NULL,
      1,
      0.465020,
      0.923579,
      0,
      1.416806,
      0,
      0,
      0,
      NULL,
      5,
      5.018253,
      1.237436,
      0.208057,
      0.798795,
      4.561934,
      0.111968,
      1.372146,
      9.658259,
      6.759010,
      9.488119,
      NULL,
      8,
      NULL,
      4.051286,
      4,
      NULL,
      NULL,
      5.115838,
      0.922908,
      NULL,
      NULL,
      3,
      0.919804,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      0.637191,
      0.531109,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      9,
      3.718704,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.861116,
      0.838986,
      NULL,
      NULL,
      NULL,
      NULL,
      0.892373,
      2,
      1.988528,
      NULL,
      0,
      2,
      0.510973,
      NULL,
      NULL,
      1.968860,
      5.298165,
      0.610352,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.775155,
      3,
      0,
      2,
      0.577909,
      0,
      1.234991,
      NULL,
      NULL,
      1,
      0.057307,
      NULL,
      NULL,
      1,
      1.760676,
      0,
      0.206234,
      1,
      0.104575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.280751,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.298763,
      '40412',
      '31201',
      NULL,
      1.772903,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      4.510842,
      2.429092,
      1,
      3,
      NULL,
      0,
      NULL,
      0.918802,
      0.642379);
commit;
end;
/


