set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-11-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '331',
      '32440112',
      NULL,
      24.908781,
      '1442211',
      169.978533,
      1,
      0.565031,
      NULL,
      '012221',
      5.956124,
      ' 5-20-1974',
      36.978616,
      3.600564,
      0,
      NULL,
      NULL,
      2,
      0.435251,
      1,
      NULL,
      NULL,
      0.735343,
      1.872151,
      NULL,
      0.225403,
      1.052886,
      1.620779,
      1.767263,
      0.816001,
      0,
      0.525744,
      0.934608,
      NULL,
      2.316007,
      1.754578,
      NULL,
      1,
      NULL,
      0,
      3,
      1,
      1.809588,
      1.904653,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      0,
      NULL,
      0.268071,
      NULL,
      NULL,
      0.935850,
      0.045272,
      1,
      3,
      1.874093,
      1,
      3.743616,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.422164,
      0,
      1,
      0.000568,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.492151,
      0,
      1.394384,
      0.697824,
      0,
      NULL,
      0.812320,
      1.545652,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      0.610152,
      NULL,
      1,
      0.065337,
      0,
      1.005825,
      0,
      0.764156,
      0.374345,
      1,
      0.546464,
      1.455705,
      NULL,
      0.791100,
      0,
      1,
      3,
      NULL,
      0.005141,
      4.743351,
      9.662768,
      2,
      7,
      9,
      6,
      6,
      NULL,
      4,
      5,
      NULL,
      0,
      NULL,
      NULL,
      4.970972,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1,
      1.931633,
      1.023858,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.506067,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.743117,
      2.653885,
      0.415996,
      NULL,
      NULL,
      NULL,
      4,
      1.019392,
      6.310766,
      2,
      4.896532,
      2,
      5.708895,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.404526,
      0,
      0,
      1,
      1.411436,
      1,
      0,
      1,
      0.197944,
      1.459037,
      NULL,
      0,
      0.499966,
      1.241122,
      0.347542,
      1.640056,
      0,
      1,
      1.727856,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.069457,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.293902,
      '20123',
      '14011',
      '',
      0.640720,
      '',
      '',
      '',
      0.936026,
      '',
      '',
      '',
      NULL,
      NULL,
      0.313212,
      2,
      1.398267,
      3,
      0.345413,
      3,
      0.467412);
commit;
end;
/


