set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-5-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '114',
      '00242213',
      53,
      36,
      '4231031',
      19.701296,
      3,
      NULL,
      3,
      '312021',
      1,
      ' 5-27-1989',
      28.907308,
      61.589084,
      NULL,
      NULL,
      NULL,
      0.498040,
      0,
      0.329312,
      0.187854,
      0.033231,
      0.199320,
      0,
      3.178699,
      0.684604,
      0,
      1,
      1.040800,
      NULL,
      1.058474,
      1.459789,
      7,
      0,
      0.388290,
      1.488031,
      0,
      0,
      1,
      NULL,
      3.969907,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.433362,
      NULL,
      1,
      2.257552,
      1,
      0,
      2,
      1,
      NULL,
      3,
      1,
      0,
      3.547769,
      2,
      1,
      NULL,
      NULL,
      1.252187,
      0,
      1,
      0,
      1.722893,
      1,
      1,
      NULL,
      NULL,
      1.408386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.273642,
      0.575356,
      0,
      1,
      0.221464,
      0.267720,
      NULL,
      0,
      0,
      0.036790,
      0,
      1.378356,
      NULL,
      NULL,
      1.069699,
      1,
      1.732483,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0.127992,
      NULL,
      0.052588,
      NULL,
      4.633655,
      4.287060,
      2.681001,
      5.582710,
      NULL,
      0.100643,
      1.285506,
      1.515593,
      0,
      5.310956,
      1.718168,
      7,
      9.271973,
      NULL,
      3,
      NULL,
      0,
      4,
      1,
      0.542685,
      0,
      NULL,
      NULL,
      0,
      0.641304,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.519634,
      1.280837,
      0,
      0,
      0,
      0.976917,
      1,
      1.129466,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      0,
      NULL,
      1,
      1,
      1.688372,
      2,
      2.030538,
      2,
      0.522107,
      NULL,
      NULL,
      NULL,
      5.416039,
      NULL,
      6,
      4,
      4.333569,
      2,
      4,
      1,
      NULL,
      NULL,
      1,
      4.416992,
      0.383090,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.116803,
      1,
      2,
      1,
      2.546647,
      2,
      NULL,
      0.697656,
      1.161831,
      1.509937,
      0,
      0.932630,
      1.406827,
      0,
      0.184640,
      0.139183,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.700566,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      '33103',
      NULL,
      1.194381,
      '',
      '',
      '',
      0.124074,
      '',
      '',
      '',
      NULL,
      2.102191,
      3.242312,
      3.702335,
      2,
      3,
      1.713916,
      NULL,
      NULL);
commit;
end;
/


